/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class SelectorTest
extends AbstractQOMTest {
    public void testSelector() throws RepositoryException {
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), null, null, null);
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            @Override
            public Object call(Query query) throws RepositoryException {
                QueryResult result = query.execute();
                String[] names = result.getSelectorNames();
                Assert.assertNotNull((Object)names);
                Assert.assertEquals((int)1, (int)names.length);
                Assert.assertEquals((String)"s", (String)names[0]);
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Assert.assertTrue((String)"Wrong node type", (boolean)it.nextNode().isNodeType(SelectorTest.this.testNodeType));
                }
                return null;
            }
        });
    }

    public void testSyntacticallyInvalidName() throws RepositoryException {
        String invalidNodeType = this.testNodeType + "[";
        try {
            QueryObjectModel q = this.qf.createQuery((Source)this.qf.selector(invalidNodeType, "s"), null, null, null);
            q.execute();
            SelectorTest.fail((String)"Selector with syntactically invalid name must throw InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + invalidNodeType + "]";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            SelectorTest.fail((String)"selectorName with syntactically invalid name must throw InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testUnknownNodeType() throws RepositoryException {
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        String ntName = this.testNodeType;
        try {
            while (true) {
                ntMgr.getNodeType(ntName);
                ntName = ntName + "x";
            }
        }
        catch (NoSuchNodeTypeException e) {
            try {
                this.qf.createQuery((Source)this.qf.selector(ntName, "s"), null, null, null).execute();
                SelectorTest.fail((String)"Selector with unknown node type must throw InvalidQueryException");
            }
            catch (InvalidQueryException e2) {
                // empty catch block
            }
            try {
                String stmt = "SELECT * FROM [" + ntName + "] AS nt";
                this.qm.createQuery(stmt, "JCR-SQL2").execute();
                SelectorTest.fail((String)"Selector with unknown node type must throw InvalidQueryException");
            }
            catch (InvalidQueryException invalidQueryException) {
                // empty catch block
            }
            return;
        }
    }

    public void testDuplicateNodeType() throws RepositoryException {
        try {
            QueryObjectModel q = this.qf.createQuery((Source)this.qf.join((Source)this.qf.selector(this.testNodeType, "nt"), (Source)this.qf.selector(this.testNodeType, "nt"), "jcr.join.type.inner", (JoinCondition)this.qf.descendantNodeJoinCondition("nt", "nt")), null, null, null);
            q.execute();
            SelectorTest.fail((String)"Selector with two identical selector names must throw InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS nt, [" + this.testNodeType + "] AS nt nt INNER JOIN nt ON ISDESCENDANTNODE(nt, nt)";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            SelectorTest.fail((String)"selectorName with syntactically invalid name must throw InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }
}

