/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class DatePropertyTest
extends AbstractPropertyTest {
    @Override
    protected int getPropertyType() {
        return 5;
    }

    @Override
    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testValue() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getDate();
                DatePropertyTest.fail((String)"Property.getDate() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            Calendar calendar = this.prop.getValue().getDate();
            Calendar calendar2 = this.prop.getDate();
            DatePropertyTest.assertEquals((String)"Value.getDate() and Property.getDate() return different values.", (Object)calendar, (Object)calendar2);
        }
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String date = val.getString();
        this.log.println("date str = " + date);
        boolean match = PropertyUtil.isDateFormat(this.prop.getString());
        DatePropertyTest.assertTrue((String)"Date not in correct String format.", (boolean)match);
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            DatePropertyTest.fail((String)"Conversion from a Date value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        double d = val.getDouble();
        long mili = val.getDate().getTimeInMillis();
        DatePropertyTest.assertEquals((String)"Conversion from a Date value to a Double value returns a different number of miliseconds.", (long)mili, (long)((long)d));
    }

    public void testGetLong() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        long l = val.getLong();
        long mili = val.getDate().getTimeInMillis();
        DatePropertyTest.assertEquals((String)"Conversion from a Date value to a Long value returns a different number of miliseconds.", (long)mili, (long)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStream() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        BufferedInputStream in = new BufferedInputStream(val.getStream());
        Value otherVal = PropertyUtil.getValue(this.prop);
        InputStream ins = null;
        byte[] utf8bytes = otherVal.getString().getBytes(UTF8);
        int i = 0;
        byte[] b = new byte[1];
        while (in.read(b) != -1) {
            DatePropertyTest.assertTrue((String)"Date as a Stream is not utf-8 encoded.", (b[0] == utf8bytes[i] ? 1 : 0) != 0);
            ++i;
        }
        try {
            val.getDate();
        }
        catch (IllegalStateException ise) {
            DatePropertyTest.fail((String)"Non stream method call after stream method call should not throw an IllegalStateException.");
        }
        try {
            ins = otherVal.getStream();
        }
        catch (IllegalStateException ise) {
            DatePropertyTest.fail((String)"Stream method call after a non stream method call should not throw an IllegalStateException.");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
    }

    public void testGetType() throws RepositoryException {
        DatePropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 5));
    }

    public void testGetNode() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getNode();
                DatePropertyTest.fail((String)"Conversion from a Date value to a Reference or Path value should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getNode();
                DatePropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetProperty() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getProperty();
                DatePropertyTest.fail((String)"Conversion from a Date value to a Path value should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getProperty();
                DatePropertyTest.fail((String)"Property.getProperty() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                DatePropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long length = this.prop.getLength();
            if (length > -1L) {
                DatePropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)length, (long)this.prop.getString().length());
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] <= -1L) continue;
                DatePropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)values[i].getString().length(), (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                DatePropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

