/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;

public class NodeMixinUtil {
    public static String getAddableMixinName(Session session, Node node) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator mixins = manager.getMixinNodeTypes();
        String mixShareable = session.getNamespacePrefix("http://www.jcp.org/jcr/mix/1.0") + ":shareable";
        while (mixins.hasNext()) {
            String name = mixins.nextNodeType().getName();
            if (!node.canAddMixin(name) || mixShareable.equals(name)) continue;
            return name;
        }
        return null;
    }

    public static String getNotAssignedMixinName(Session session, Node node) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator mixins = manager.getMixinNodeTypes();
        HashSet<String> existingMixins = new HashSet<String>();
        for (NodeType nt : node.getMixinNodeTypes()) {
            existingMixins.add(nt.getName());
        }
        while (mixins.hasNext()) {
            String ntName = mixins.nextNodeType().getName();
            if (existingMixins.contains(ntName)) continue;
            return ntName;
        }
        return null;
    }

    public static String getNonExistingMixinName(Session session) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator mixins = manager.getMixinNodeTypes();
        StringBuffer s = new StringBuffer("X");
        while (mixins.hasNext()) {
            s.append(mixins.nextNodeType().getName());
        }
        return s.toString().replaceAll(":", "");
    }
}

