/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceSameNameSibsTest;

public class WorkspaceCopyBetweenWorkspacesSameNameSibsTest
extends AbstractWorkspaceSameNameSibsTest {
    public void testCopyNodesOrderingSupportedByParent() throws RepositoryException {
        String[] orderList = new String[]{this.nodeName1, this.nodeName2, this.nodeName3};
        for (int i = 0; i < orderList.length; ++i) {
            this.workspaceW2.copy(this.workspace.getName(), this.node1.getPath(), this.node2.getPath() + "/" + orderList[i]);
        }
        int cnt = 0;
        NodeIterator iter = this.node2.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            WorkspaceCopyBetweenWorkspacesSameNameSibsTest.assertTrue((boolean)n.getName().equals(orderList[cnt]));
            ++cnt;
        }
    }

    public void testCopyNodesNodeExistsAtDestPath() throws RepositoryException {
        Node snsfNode = this.testRootNodeW2.addNode(this.nodeName3, this.sameNameSibsFalseNodeType.getName());
        this.testRootNodeW2.save();
        String dstAbsPath = snsfNode.getPath() + "/" + this.node1.getName();
        this.workspaceW2.copy(this.node1.getPath(), dstAbsPath);
        try {
            this.workspaceW2.copy(this.workspace.getName(), this.node1.getPath(), dstAbsPath);
            WorkspaceCopyBetweenWorkspacesSameNameSibsTest.fail((String)("Node exists below '" + dstAbsPath + "'. Test should fail."));
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }
}

