/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionManager;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.retention.AbstractRetentionTest;

public class HoldTest
extends AbstractRetentionTest {
    private static boolean containsHold(Hold[] holds, Hold toTest) throws RepositoryException {
        for (int i = 0; i < holds.length; ++i) {
            if (!holds[i].getName().equals(toTest.getName()) || holds[i].isDeep() != toTest.isDeep()) continue;
            return true;
        }
        return false;
    }

    public void testAddHold() throws RepositoryException, NotExecutableException {
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        Hold[] holds = this.retentionMgr.getHolds(this.testNodePath);
        HoldTest.assertTrue((String)"getHolds must return the hold added before.", (holds.length >= 1 ? 1 : 0) != 0);
        HoldTest.assertTrue((String)"getHolds doesn't return the hold added before", (boolean)HoldTest.containsHold(holds, hold));
    }

    public void testAddHold2() throws RepositoryException, NotExecutableException {
        Hold[] holdsBefore = this.retentionMgr.getHolds(this.testNodePath);
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        HoldTest.assertFalse((String)"The hold added must not have been present before.", (boolean)HoldTest.containsHold(holdsBefore, hold));
    }

    public void testAddHoldIsTransient() throws RepositoryException, NotExecutableException {
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        Hold[] holds = this.retentionMgr.getHolds(this.testNodePath);
        this.superuser.refresh(false);
        Hold[] holds2 = this.retentionMgr.getHolds(this.testNodePath);
        HoldTest.assertEquals((String)"Reverting transient changes must revert the hold added.", (int)(holds.length - 1), (int)holds2.length);
        HoldTest.assertFalse((String)"Reverting transient changes must revert the hold added.", (boolean)HoldTest.containsHold(holds2, hold));
    }

    public void testRemoveHold() throws RepositoryException, NotExecutableException {
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        Hold[] holds = this.retentionMgr.getHolds(this.testNodePath);
        this.retentionMgr.removeHold(this.testNodePath, hold);
        Hold[] holds2 = this.retentionMgr.getHolds(this.testNodePath);
        HoldTest.assertEquals((String)"RetentionManager.removeHold should removed the hold added before.", (int)(holds.length - 1), (int)holds2.length);
        HoldTest.assertFalse((String)"RetentionManager.removeHold should removed the hold added before.", (boolean)HoldTest.containsHold(holds2, hold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveHoldIsTransient() throws RepositoryException, NotExecutableException {
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        this.superuser.save();
        try {
            Hold[] holds = this.retentionMgr.getHolds(this.testNodePath);
            this.retentionMgr.removeHold(this.testNodePath, hold);
            this.superuser.refresh(false);
            Hold[] holds2 = this.retentionMgr.getHolds(this.testNodePath);
            HoldTest.assertEquals((String)"Reverting transient hold removal must restore the original state.", Arrays.asList(holds), Arrays.asList(holds2));
        }
        finally {
            this.retentionMgr.removeHold(this.testNodePath, hold);
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveHoldFromChild() throws RepositoryException, NotExecutableException {
        String childPath = this.testRootNode.addNode(this.nodeName2, this.testNodeType).getPath();
        Hold hold = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        try {
            this.retentionMgr.removeHold(childPath, hold);
            HoldTest.fail((String)"Removing hold from another node must fail");
        }
        catch (RepositoryException e) {
            HoldTest.assertTrue((boolean)HoldTest.containsHold(this.retentionMgr.getHolds(this.testNodePath), hold));
        }
        this.superuser.save();
        try {
            this.retentionMgr.removeHold(childPath, hold);
            HoldTest.fail((String)"Removing hold from another node must fail");
        }
        catch (RepositoryException e) {
            HoldTest.assertTrue((boolean)HoldTest.containsHold(this.retentionMgr.getHolds(this.testNodePath), hold));
        }
        finally {
            this.retentionMgr.removeHold(this.testNodePath, hold);
            this.superuser.save();
        }
    }

    public void testInvalidPath() throws RepositoryException, NotExecutableException {
        String invalidPath = this.testPath;
        try {
            this.retentionMgr.getHolds(invalidPath);
            HoldTest.fail((String)"Accessing holds an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.addHold(invalidPath, this.getHoldName(), true);
            HoldTest.fail((String)"Adding a hold at an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
            this.retentionMgr.removeHold(invalidPath, h);
            HoldTest.fail((String)"Removing a hold at an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testNonExistingNodePath() throws RepositoryException, NotExecutableException {
        String invalidPath = this.testNodePath + "/nonexisting";
        int cnt = 0;
        while (this.superuser.nodeExists(invalidPath)) {
            invalidPath = invalidPath + cnt++;
        }
        try {
            this.retentionMgr.getHolds(invalidPath);
            HoldTest.fail((String)"Accessing holds from non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.addHold(invalidPath, this.getHoldName(), true);
            HoldTest.fail((String)"Adding a hold for a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
            this.retentionMgr.removeHold(invalidPath, h);
            HoldTest.fail((String)"Removing a hold at a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testPropertyPath() throws RepositoryException, NotExecutableException {
        String propPath = null;
        PropertyIterator it = this.testRootNode.getProperties();
        while (it.hasNext()) {
            String path = it.nextProperty().getPath();
            if (this.superuser.nodeExists(path)) continue;
            propPath = path;
            break;
        }
        if (propPath == null) {
            throw new NotExecutableException();
        }
        try {
            this.retentionMgr.getHolds(propPath);
            HoldTest.fail((String)"Accessing holds from non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.addHold(propPath, this.getHoldName(), true);
            HoldTest.fail((String)"Adding a hold for a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
            this.retentionMgr.removeHold(propPath, h);
            HoldTest.fail((String)"Removing a hold at a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testInvalidName() {
        try {
            String invalidName = "*.[y]";
            this.retentionMgr.addHold(this.testNodePath, invalidName, false);
            HoldTest.fail((String)"Adding a hold with an invalid JCR name must fail.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlySession() throws NotExecutableException, RepositoryException {
        Session s = this.getHelper().getReadOnlySession();
        try {
            RetentionManager rmgr = HoldTest.getRetentionManager(s);
            try {
                rmgr.getHolds(this.testNodePath);
                HoldTest.fail((String)"Read-only session doesn't have sufficient privileges to retrieve holds.");
            }
            catch (AccessDeniedException e) {
                // empty catch block
            }
            try {
                rmgr.addHold(this.testNodePath, this.getHoldName(), false);
                HoldTest.fail((String)"Read-only session doesn't have sufficient privileges to retrieve holds.");
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        finally {
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddHoldOnLockedNode() throws NotExecutableException, RepositoryException {
        Node child = this.getLockedChildNode();
        List<Hold> holdsBefore = Arrays.asList(this.retentionMgr.getHolds(child.getPath()));
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = HoldTest.getRetentionManager(otherS);
            rmgr.addHold(child.getPath(), this.getHoldName(), false);
            otherS.save();
            HoldTest.fail((String)"Adding hold on a locked node must throw LockException.");
        }
        catch (LockException e) {
        }
        finally {
            otherS.logout();
            ArrayList<Hold> holds = new ArrayList<Hold>(Arrays.asList(this.retentionMgr.getHolds(child.getPath())));
            if (holds.removeAll(holdsBefore)) {
                Iterator it = holds.iterator();
                while (it.hasNext()) {
                    this.retentionMgr.removeHold(child.getPath(), (Hold)it.next());
                }
            }
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveHoldOnLockedNode() throws NotExecutableException, RepositoryException {
        Node child = this.getLockedChildNode();
        Hold h = this.retentionMgr.addHold(child.getPath(), this.getHoldName(), false);
        this.testRootNode.getSession().save();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = HoldTest.getRetentionManager(otherS);
            Hold[] holds = rmgr.getHolds(child.getPath());
            if (holds.length > 0) {
                rmgr.removeHold(child.getPath(), holds[0]);
                otherS.save();
                HoldTest.fail((String)"Removing a hold on a locked node must throw LockException.");
            }
        }
        catch (LockException e) {
        }
        finally {
            otherS.logout();
            try {
                this.retentionMgr.removeHold(child.getPath(), h);
                this.superuser.save();
            }
            catch (RepositoryException e) {}
        }
    }

    private Node getLockedChildNode() throws NotExecutableException, RepositoryException {
        this.checkSupportedOption("option.locking.supported");
        Node child = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(child, this.mixLockable);
        this.testRootNode.getSession().save();
        child.lock(false, true);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddHoldOnCheckedInNode() throws NotExecutableException, RepositoryException {
        Node child = this.getVersionableChildNode();
        child.checkout();
        child.checkin();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = HoldTest.getRetentionManager(otherS);
            rmgr.addHold(child.getPath(), this.getHoldName(), false);
            otherS.save();
            HoldTest.fail((String)"Adding hold on a checked-in node must throw VersionException.");
        }
        catch (VersionException e) {
        }
        finally {
            otherS.logout();
            child.checkout();
            Hold[] holds = this.retentionMgr.getHolds(child.getPath());
            for (int i = 0; i < holds.length; ++i) {
                this.retentionMgr.removeHold(child.getPath(), holds[i]);
            }
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveHoldOnCheckedInNode() throws NotExecutableException, RepositoryException {
        Node vn = this.getVersionableChildNode();
        vn.checkout();
        Node n = vn.addNode(this.nodeName2);
        Hold h = this.retentionMgr.addHold(n.getPath(), this.getHoldName(), false);
        this.superuser.save();
        vn.checkin();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = HoldTest.getRetentionManager(otherS);
            Hold[] holds = rmgr.getHolds(n.getPath());
            if (holds.length > 0) {
                rmgr.removeHold(n.getPath(), holds[0]);
                otherS.save();
                HoldTest.fail((String)"Removing a hold on a checked-in node must throw VersionException.");
            }
        }
        catch (VersionException e) {
        }
        finally {
            otherS.logout();
            vn.checkout();
            try {
                this.retentionMgr.removeHold(n.getPath(), h);
                this.superuser.save();
            }
            catch (RepositoryException e) {}
        }
    }

    private Node getVersionableChildNode() throws NotExecutableException, RepositoryException {
        this.checkSupportedOption("option.versioning.supported");
        Node child = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(child, this.mixVersionable);
        this.testRootNode.getSession().save();
        return child;
    }

    public void testHoldGetName() throws RepositoryException, NotExecutableException {
        String holdName = this.getHoldName();
        Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        HoldTest.assertEquals((String)"Hold.getName() must return the specified name.", (String)holdName, (String)h.getName());
    }

    public void testHoldGetName2() throws RepositoryException, NotExecutableException {
        String holdName = this.getHoldName();
        Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        HoldTest.assertEquals((String)"Hold.getName() must return the specified name.", (String)holdName, (String)h.getName());
    }

    public void testHoldIsDeep() throws RepositoryException, NotExecutableException {
        Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        HoldTest.assertEquals((String)"Hold.isDeep() must reflect the specified flag.", (boolean)false, (boolean)h.isDeep());
    }

    public void testHoldIsDeep2() throws RepositoryException, NotExecutableException {
        Hold h = this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        HoldTest.assertEquals((String)"Hold.isDeep() must reflect the specified flag.", (boolean)true, (boolean)h.isDeep());
    }
}

