/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class AbstractVersionTest
extends AbstractJCRTest {
    protected NodeType versionableNodeType;
    protected NodeType nonVersionableNodeType;
    protected Node versionableNode;
    protected Node nonVersionableNode;
    protected String propertyValue;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.checkSupportedOption("option.versioning.supported");
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        try {
            NodeType versionableNt = ntMgr.getNodeType(this.mixVersionable);
            if (versionableNt == null) {
                AbstractVersionTest.fail((String)"Repository does not support Versioning: mixin nodetype 'mix:versionable' is missing.");
            }
        }
        catch (NoSuchNodeTypeException e) {
            AbstractVersionTest.fail((String)"Repository does not support Versioning: mixin nodetype 'mix:versionable' is missing.");
        }
        String versionableNodeTypeName = this.getProperty("versionableNodeType");
        try {
            this.versionableNodeType = ntMgr.getNodeType(versionableNodeTypeName);
            if (this.versionableNodeType == null) {
                AbstractVersionTest.fail((String)("Property 'versionableNodeType' does not define a valid nodetype: '" + versionableNodeTypeName + "'"));
            }
        }
        catch (NoSuchNodeTypeException e) {
            AbstractVersionTest.fail((String)("Property 'versionableNodeType' does not define an existing nodetype: '" + versionableNodeTypeName + "'"));
        }
        try {
            this.nonVersionableNodeType = ntMgr.getNodeType(this.testNodeType);
            if (this.nonVersionableNodeType == null || this.nonVersionableNodeType.isNodeType(this.mixVersionable)) {
                AbstractVersionTest.fail((String)("Property 'testNodeType' does define a versionable nodetype: '" + this.testNodeType + "'"));
            }
        }
        catch (NoSuchNodeTypeException e) {
            AbstractVersionTest.fail((String)("Property 'testNodeType' does not define an existing nodetype: '" + this.testNodeType + "'"));
        }
        try {
            this.versionableNode = this.createVersionableNode(this.testRootNode, this.nodeName1, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            AbstractVersionTest.fail((String)("Failed to create versionable test node." + e.getMessage()));
        }
        try {
            this.nonVersionableNode = this.testRootNode.addNode(this.nodeName3, this.nonVersionableNodeType.getName());
            this.testRootNode.getSession().save();
        }
        catch (RepositoryException e) {
            AbstractVersionTest.fail((String)("Failed to create non-versionable test node." + e.getMessage()));
        }
        this.propertyValue = this.getProperty("propertyValue");
        if (this.propertyValue == null) {
            AbstractVersionTest.fail((String)"Property 'propertyValue' is not defined.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.versionableNode != null) {
                this.versionableNode.remove();
            }
            this.testRootNode.getSession().save();
        }
        catch (Exception e) {
            this.log.println("Exception in tearDown: " + e.toString());
        }
        finally {
            this.versionableNodeType = null;
            this.nonVersionableNodeType = null;
            this.versionableNode = null;
            this.nonVersionableNode = null;
            super.tearDown();
        }
    }

    protected long getNumberOfVersions(VersionHistory vHistory) throws RepositoryException {
        return this.getSize((RangeIterator)vHistory.getAllVersions());
    }

    protected Node createVersionableNode(Node parent, String name, NodeType nodetype) throws RepositoryException, NotExecutableException {
        Node versionableNode = parent.addNode(name, nodetype.getName());
        this.ensureMixinType(versionableNode, this.mixVersionable);
        parent.save();
        return versionableNode;
    }
}

