/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.jcr2spi.ItemCache;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCacheImpl
implements ItemCache,
Dumpable {
    private static Logger log;
    private final Map cache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.ItemCacheImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    ItemCacheImpl(int maxSize) {
        this.cache = new LRUMap(maxSize);
    }

    public Item getItem(ItemState state) {
        return (Item)this.cache.get(state);
    }

    public void clear() {
        this.cache.clear();
    }

    public void itemCreated(Item item) {
        if (!(item instanceof ItemImpl)) {
            StringBuffer stringBuffer = new StringBuffer("Incompatible Item object: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.jackrabbit.jcr2spi.ItemImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = stringBuffer.append(clazz.getName()).append(" expected.").toString();
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("created item " + item);
        }
        this.cacheItem(((ItemImpl)item).getItemState(), item);
    }

    public void itemUpdated(Item item, boolean modified) {
        ItemState state;
        Item cacheEntry;
        if (!(item instanceof ItemImpl)) {
            StringBuffer stringBuffer = new StringBuffer("Incompatible Item object: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.jackrabbit.jcr2spi.ItemImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = stringBuffer.append(clazz.getName()).append(" expected.").toString();
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("update item " + item);
        }
        if ((cacheEntry = this.getItem(state = ((ItemImpl)item).getItemState())) == null) {
            this.cacheItem(state, item);
        }
    }

    public void itemDestroyed(Item item) {
        if (!(item instanceof ItemImpl)) {
            StringBuffer stringBuffer = new StringBuffer("Incompatible Item object: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.apache.jackrabbit.jcr2spi.ItemImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String msg = stringBuffer.append(clazz.getName()).append(" expected.").toString();
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + item);
        }
        ((ItemImpl)item).removeLifeCycleListener(this);
        this.evictItem(((ItemImpl)item).getItemState());
    }

    private synchronized void cacheItem(ItemState state, Item item) {
        if (this.cache.containsKey(state)) {
            log.warn("overwriting cached item " + state);
        }
        if (log.isDebugEnabled()) {
            log.debug("caching item " + state);
        }
        this.cache.put(state, item);
    }

    private synchronized void evictItem(ItemState itemState) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + itemState + " from cache");
        }
        this.cache.remove(itemState);
    }

    public void dump(PrintStream ps) {
        Iterator iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            String path;
            ItemState state = (ItemState)iter.next();
            Item item = (Item)this.cache.get(state);
            if (item.isNode()) {
                ps.print("Node: ");
            } else {
                ps.print("Property: ");
            }
            if (item.isNew()) {
                ps.print("new ");
            } else if (item.isModified()) {
                ps.print("modified ");
            } else {
                ps.print("- ");
            }
            try {
                path = item.getPath();
            }
            catch (RepositoryException e) {
                path = "-";
            }
            ps.println(state + "\t" + path + " (" + item + ")");
        }
    }
}

