/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.PrintStream;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.jcr2spi.ItemCache;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.LazyItemIterator;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.PropertyImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.WorkspaceImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.jcr2spi.version.VersionHistoryImpl;
import org.apache.jackrabbit.jcr2spi.version.VersionImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemManagerImpl
implements Dumpable,
ItemManager,
ItemStateCreationListener {
    private static Logger log;
    private final SessionImpl session;
    private final HierarchyManager hierMgr;
    private final ItemCache itemCache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.ItemManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    ItemManagerImpl(HierarchyManager hierMgr, SessionImpl session, ItemCache cache) {
        this.hierMgr = hierMgr;
        this.session = session;
        this.itemCache = cache;
        Workspace wsp = session.getWorkspace();
        if (wsp instanceof WorkspaceImpl) {
            ((WorkspaceImpl)wsp).getItemStateFactory().addCreationListener(this);
        }
    }

    public void dispose() {
        Workspace wsp = this.session.getWorkspace();
        if (wsp instanceof WorkspaceImpl) {
            ((WorkspaceImpl)wsp).getItemStateFactory().removeCreationListener(this);
        }
        this.itemCache.clear();
    }

    public boolean nodeExists(Path path) {
        try {
            NodeState nodeState = this.hierMgr.getNodeState(path);
            return this.itemExists(nodeState);
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
        catch (ItemNotFoundException infe) {
            return false;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean propertyExists(Path path) {
        try {
            PropertyState propState = this.hierMgr.getPropertyState(path);
            return this.itemExists(propState);
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
        catch (ItemNotFoundException infe) {
            return false;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public boolean itemExists(HierarchyEntry hierarchyEntry) {
        try {
            ItemState state = hierarchyEntry.getItemState();
            return this.itemExists(state);
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean itemExists(ItemState itemState) {
        try {
            this.session.checkIsAlive();
            return itemState.isValid();
        }
        catch (ItemNotFoundException infe) {
            return false;
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public synchronized Node getNode(Path path) throws PathNotFoundException, RepositoryException {
        NodeEntry nodeEntry = this.hierMgr.getNodeEntry(path);
        try {
            return (Node)this.getItem(nodeEntry);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(LogUtil.safeGetJCRPath(path, this.session.getPathResolver()));
        }
    }

    public synchronized Property getProperty(Path path) throws PathNotFoundException, RepositoryException {
        PropertyEntry propertyEntry = this.hierMgr.getPropertyEntry(path);
        try {
            return (Property)this.getItem(propertyEntry);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(LogUtil.safeGetJCRPath(path, this.session.getPathResolver()));
        }
    }

    public Item getItem(HierarchyEntry hierarchyEntry) throws ItemNotFoundException, RepositoryException {
        this.session.checkIsAlive();
        ItemState state = hierarchyEntry.getItemState();
        if (!state.isValid()) {
            throw new ItemNotFoundException(LogUtil.safeGetJCRPath(state, this.session.getPathResolver()));
        }
        Item item = this.itemCache.getItem(state);
        if (item == null) {
            item = hierarchyEntry.denotesNode() ? this.createNodeInstance((NodeState)state) : this.createPropertyInstance((PropertyState)state);
        }
        return item;
    }

    public synchronized boolean hasChildNodes(NodeEntry parentEntry) throws ItemNotFoundException, RepositoryException {
        this.session.checkIsAlive();
        Iterator iter = parentEntry.getNodeEntries();
        while (iter.hasNext()) {
            try {
                NodeEntry entry = (NodeEntry)iter.next();
                entry.getNodeState();
                return true;
            }
            catch (ItemNotFoundException e) {
                log.debug("Failed to access node state.", (Throwable)e);
            }
        }
        return false;
    }

    public synchronized NodeIterator getChildNodes(NodeEntry parentEntry) throws ItemNotFoundException, RepositoryException {
        this.session.checkIsAlive();
        Iterator it = parentEntry.getNodeEntries();
        return new LazyItemIterator(this, it);
    }

    public synchronized boolean hasChildProperties(NodeEntry parentEntry) throws ItemNotFoundException, RepositoryException {
        this.session.checkIsAlive();
        Iterator iter = parentEntry.getPropertyEntries();
        while (iter.hasNext()) {
            try {
                PropertyEntry entry = (PropertyEntry)iter.next();
                entry.getPropertyState();
                return true;
            }
            catch (ItemNotFoundException e) {
                log.debug("Failed to access node state.", (Throwable)e);
            }
        }
        return false;
    }

    public synchronized PropertyIterator getChildProperties(NodeEntry parentEntry) throws ItemNotFoundException, RepositoryException {
        this.session.checkIsAlive();
        Iterator propEntries = parentEntry.getPropertyEntries();
        return new LazyItemIterator(this, propEntries);
    }

    public void dump(PrintStream ps) {
        ps.println("ItemManager (" + this + ")");
        ps.println();
        ps.println("Items in cache:");
        ps.println();
        if (this.itemCache instanceof Dumpable) {
            ((Dumpable)((Object)this.itemCache)).dump(ps);
        } else {
            ps.println("ItemCache (" + this.itemCache.toString() + ")");
        }
    }

    private NodeImpl createNodeInstance(NodeState state) throws RepositoryException {
        ItemLifeCycleListener[] listeners = new ItemLifeCycleListener[]{this.itemCache};
        Name ntName = state.getNodeTypeName();
        if (NameConstants.NT_VERSION.equals(ntName)) {
            return new VersionImpl(this.session, state, listeners);
        }
        if (NameConstants.NT_VERSIONHISTORY.equals(ntName)) {
            return new VersionHistoryImpl(this.session, state, listeners);
        }
        return new NodeImpl(this.session, state, listeners);
    }

    private PropertyImpl createPropertyInstance(PropertyState state) {
        ItemLifeCycleListener[] listeners = new ItemLifeCycleListener[]{this.itemCache};
        PropertyImpl prop = new PropertyImpl(this.session, state, listeners);
        return prop;
    }

    public void created(ItemState state) {
        if (state.isNode()) {
            try {
                this.createNodeInstance((NodeState)state);
            }
            catch (RepositoryException e) {
                log.warn("Unable to create Node instance: " + e.getMessage());
            }
        } else {
            this.createPropertyInstance((PropertyState)state);
        }
    }

    public void statusChanged(ItemState state, int previousStatus) {
        if (8 == state.getStatus()) {
            state.removeListener(this);
        }
    }
}

