/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.XASessionImpl;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.XASessionInfo;

public class RepositoryImpl
extends AbstractRepository
implements Referenceable {
    private final RepositoryConfig config;
    private final Map descriptors;
    private Reference reference = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private RepositoryImpl(RepositoryConfig config) throws RepositoryException {
        this.config = config;
        this.descriptors = config.getRepositoryService().getRepositoryDescriptors();
    }

    public static Repository create(RepositoryConfig config) throws RepositoryException {
        return new RepositoryImpl(config);
    }

    public String[] getDescriptorKeys() {
        String[] keys = this.descriptors.keySet().toArray(new String[this.descriptors.keySet().size()]);
        return keys;
    }

    public String getDescriptor(String descriptorKey) {
        return (String)this.descriptors.get(descriptorKey);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfo info = this.config.getRepositoryService().obtain(credentials, workspaceName);
        try {
            if (info instanceof XASessionInfo) {
                return new XASessionImpl((XASessionInfo)info, (Repository)this, this.config);
            }
            return new SessionImpl(info, (Repository)this, this.config);
        }
        catch (RepositoryException ex) {
            this.config.getRepositoryService().dispose(info);
            throw ex;
        }
    }

    public Reference getReference() throws NamingException {
        if (this.config instanceof Referenceable) {
            Referenceable confref = (Referenceable)((Object)this.config);
            if (this.reference == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.RepositoryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String string = clazz.getName();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.apache.jackrabbit.jcr2spi.RepositoryImpl$Factory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.reference = new Reference(string, clazz2.getName(), null);
                Enumeration<RefAddr> en = confref.getReference().getAll();
                while (en.hasMoreElements()) {
                    this.reference.add(en.nextElement());
                }
                this.reference.add(new StringRefAddr(Factory.RCF, confref.getReference().getFactoryClassName()));
                this.reference.add(new StringRefAddr(Factory.RCC, this.config.getClass().getName()));
            }
            return this.reference;
        }
        throw new OperationNotSupportedException("Contained RepositoryConfig needs to implement javax.naming.Referenceable");
    }

    public static class Factory
    implements ObjectFactory {
        public static final String RCF;
        public static final String RCC;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.RepositoryImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RCF = String.valueOf(clazz.getName()) + ".factory";
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.RepositoryImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            RCC = String.valueOf(clazz2.getName()) + ".class";
        }

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            Object res = null;
            if (obj instanceof Reference) {
                Reference ref = (Reference)obj;
                String classname = ref.getClassName();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.RepositoryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.getName().equals(classname)) {
                    RefAddr rfac = ref.get(RCF);
                    if (rfac == null || !(rfac instanceof StringRefAddr)) {
                        throw new Exception("Address type " + RCF + " missing or of wrong class: " + rfac);
                    }
                    String configFactoryClassName = (String)((StringRefAddr)rfac).getContent();
                    RefAddr rclas = ref.get(RCC);
                    if (rclas == null || !(rclas instanceof StringRefAddr)) {
                        throw new Exception("Address type " + RCC + " missing or of wrong class: " + rclas);
                    }
                    String repositoryConfigClassName = (String)((StringRefAddr)rclas).getContent();
                    Object rof = Class.forName(configFactoryClassName).newInstance();
                    if (!(rof instanceof ObjectFactory)) {
                        throw new Exception(rof + " must implement ObjectFactory");
                    }
                    ObjectFactory of = (ObjectFactory)rof;
                    Reference newref = new Reference(repositoryConfigClassName, configFactoryClassName, null);
                    Enumeration<RefAddr> en = ref.getAll();
                    while (en.hasMoreElements()) {
                        RefAddr ra = en.nextElement();
                        String type = ra.getType();
                        if (RCF.equals(type) || RCC.equals(type)) continue;
                        newref.add(ra);
                    }
                    Object config = of.getObjectInstance(newref, name, nameCtx, environment);
                    if (!(config instanceof RepositoryConfig)) {
                        throw new Exception(config + " must implement RepositoryConfig");
                    }
                    return RepositoryImpl.create((RepositoryConfig)config);
                }
                throw new Exception("Unexpected class: " + classname);
            }
            return res;
        }
    }
}

