/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.lock.LockManager;
import org.apache.jackrabbit.jcr2spi.lock.LockManagerImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.observation.ObservationManagerImpl;
import org.apache.jackrabbit.jcr2spi.operation.Clone;
import org.apache.jackrabbit.jcr2spi.operation.Copy;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.WorkspaceImport;
import org.apache.jackrabbit.jcr2spi.query.QueryManagerImpl;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateValidator;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.jcr2spi.version.VersionManagerImpl;
import org.apache.jackrabbit.jcr2spi.xml.WorkspaceContentHandler;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class WorkspaceImpl
implements Workspace,
ManagerProvider {
    private static Logger log;
    private final String name;
    protected final SessionImpl session;
    private final WorkspaceManager wspManager;
    private LockManager lockManager;
    private ObservationManager obsManager;
    private QueryManager qManager;
    private VersionManager versionManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.WorkspaceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public WorkspaceImpl(String name, SessionImpl session, RepositoryConfig config, SessionInfo sessionInfo) throws RepositoryException {
        this.name = name;
        this.session = session;
        this.wspManager = this.createManager(config.getRepositoryService(), sessionInfo, session.getCacheBehaviour(), session.getPollTimeout());
    }

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        return this.name;
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        Path srcPath = this.session.getQPath(srcAbsPath);
        Path destPath = this.session.getQPath(destAbsPath);
        Operation op = Copy.create(srcPath, destPath, this.getName(), this, this);
        this.getUpdatableItemStateManager().execute(op);
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        if (this.getName().equals(srcWorkspace)) {
            this.copy(srcAbsPath, destAbsPath);
            return;
        }
        this.session.checkAccessibleWorkspace(srcWorkspace);
        Path srcPath = this.session.getQPath(srcAbsPath);
        Path destPath = this.session.getQPath(destAbsPath);
        SessionImpl srcSession = null;
        try {
            srcSession = this.session.switchWorkspace(srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            Operation op = Copy.create(srcPath, destPath, srcWsp.getName(), srcWsp, this);
            this.getUpdatableItemStateManager().execute(op);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        if (this.getName().equals(srcWorkspace)) {
            String msg = String.valueOf(srcWorkspace) + ": illegal workspace (same as current)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.session.checkAccessibleWorkspace(srcWorkspace);
        Path srcPath = this.session.getQPath(srcAbsPath);
        Path destPath = this.session.getQPath(destAbsPath);
        SessionImpl srcSession = null;
        try {
            srcSession = this.session.switchWorkspace(srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            Operation op = Clone.create(srcPath, destPath, srcWsp.getName(), removeExisting, srcWsp, this);
            this.getUpdatableItemStateManager().execute(op);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        Path srcPath = this.session.getQPath(srcAbsPath);
        Path destPath = this.session.getQPath(destAbsPath);
        Operation op = Move.create(srcPath, destPath, this.getHierarchyManager(), this.getPathResolver(), false);
        this.getUpdatableItemStateManager().execute(op);
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkHasPendingChanges();
        NodeState[] versionStates = new NodeState[versions.length];
        int i = 0;
        while (i < versions.length) {
            versionStates[i] = this.session.getVersionState(versions[i]);
            ++i;
        }
        this.getVersionManager().restore(versionStates, removeExisting);
    }

    public QueryManager getQueryManager() throws RepositoryException {
        this.session.checkIsAlive();
        if (this.qManager == null) {
            this.qManager = new QueryManagerImpl((Session)this.session, this.session, this.session.getItemManager(), this.wspManager);
        }
        return this.qManager;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.session.checkIsAlive();
        return this.wspManager.getNamespaceRegistryImpl();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.session.checkIsAlive();
        return this.session.getNodeTypeManager();
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkSupportedOption("option.observation.supported");
        this.session.checkIsAlive();
        if (this.obsManager == null) {
            this.obsManager = this.createObservationManager(this.getNamePathResolver(), this.getNodeTypeRegistry());
        }
        return this.obsManager;
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.session.checkIsAlive();
        return this.wspManager.getWorkspaceNames();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        Path parentPath = this.session.getQPath(parentAbsPath);
        NodeState parentState = this.getHierarchyManager().getNodeState(parentPath);
        int options = 7;
        this.getValidator().checkIsWritable(parentState, options);
        return new WorkspaceContentHandler(this, parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, RepositoryException {
        this.session.checkSupportedOption("level.2.supported");
        this.session.checkIsAlive();
        Path parentPath = this.session.getQPath(parentAbsPath);
        NodeState parentState = this.getHierarchyManager().getNodeState(parentPath);
        int options = 7;
        this.getValidator().checkIsWritable(parentState, options);
        this.wspManager.execute(WorkspaceImport.create(parentState, in, uuidBehavior));
    }

    public NamePathResolver getNamePathResolver() {
        return this.session.getNamePathResolver();
    }

    public NameResolver getNameResolver() {
        return this.session.getNameResolver();
    }

    public PathResolver getPathResolver() {
        return this.session.getPathResolver();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.session.getNamespaceResolver();
    }

    public HierarchyManager getHierarchyManager() {
        return this.wspManager.getHierarchyManager();
    }

    public AccessManager getAccessManager() {
        return this.wspManager;
    }

    public LockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager(this.wspManager, this.session.getItemManager());
        }
        return this.lockManager;
    }

    public VersionManager getVersionManager() {
        if (this.versionManager == null) {
            this.versionManager = this.createVersionManager(this.wspManager);
        }
        return this.versionManager;
    }

    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.wspManager.getItemDefinitionProvider();
    }

    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.wspManager.getEffectiveNodeTypeProvider();
    }

    public ValueFactory getJcrValueFactory() throws RepositoryException {
        return this.session.getJcrValueFactory();
    }

    public QValueFactory getQValueFactory() throws RepositoryException {
        return this.session.getQValueFactory();
    }

    void dispose() {
    }

    NameFactory getNameFactory() throws RepositoryException {
        return this.wspManager.getNameFactory();
    }

    PathFactory getPathFactory() throws RepositoryException {
        return this.wspManager.getPathFactory();
    }

    IdFactory getIdFactory() throws RepositoryException {
        return this.wspManager.getIdFactory();
    }

    NodeTypeRegistry getNodeTypeRegistry() {
        return this.wspManager.getNodeTypeRegistry();
    }

    UpdatableItemStateManager getUpdatableItemStateManager() {
        return this.wspManager;
    }

    ItemStateFactory getItemStateFactory() {
        return this.wspManager.getItemStateFactory();
    }

    private ItemStateValidator getValidator() {
        return this.session.getValidator();
    }

    protected WorkspaceManager createManager(RepositoryService service, SessionInfo sessionInfo, CacheBehaviour cacheBehaviour, int pollTimeout) throws RepositoryException {
        return new WorkspaceManager(service, sessionInfo, cacheBehaviour, pollTimeout, this.session.isSupportedOption("option.observation.supported"));
    }

    protected LockManager createLockManager(WorkspaceManager wspManager, ItemManager itemManager) {
        LockManagerImpl lMgr = new LockManagerImpl(wspManager, itemManager, this.session.getCacheBehaviour(), this.getPathResolver());
        this.session.addListener(lMgr);
        return lMgr;
    }

    protected VersionManager createVersionManager(WorkspaceManager wspManager) {
        return new VersionManagerImpl(wspManager);
    }

    protected ObservationManager createObservationManager(NamePathResolver resolver, NodeTypeRegistry ntRegistry) {
        return new ObservationManagerImpl(this.wspManager, resolver, ntRegistry);
    }
}

