/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.NamespaceRegistryImpl;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEventListener;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManagerImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProviderImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.jcr2spi.observation.InternalEventListener;
import org.apache.jackrabbit.jcr2spi.operation.AddLabel;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Checkin;
import org.apache.jackrabbit.jcr2spi.operation.Checkout;
import org.apache.jackrabbit.jcr2spi.operation.Clone;
import org.apache.jackrabbit.jcr2spi.operation.Copy;
import org.apache.jackrabbit.jcr2spi.operation.LockOperation;
import org.apache.jackrabbit.jcr2spi.operation.LockRefresh;
import org.apache.jackrabbit.jcr2spi.operation.LockRelease;
import org.apache.jackrabbit.jcr2spi.operation.Merge;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.RemoveLabel;
import org.apache.jackrabbit.jcr2spi.operation.RemoveVersion;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.ResolveMergeConflict;
import org.apache.jackrabbit.jcr2spi.operation.Restore;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.operation.Update;
import org.apache.jackrabbit.jcr2spi.operation.WorkspaceImport;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.state.ChangeLog;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.TransientISFactory;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.state.WorkspaceItemStateFactory;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceManager
implements UpdatableItemStateManager,
NamespaceStorage,
AccessManager {
    private static Logger log;
    private final RepositoryService service;
    private final SessionInfo sessionInfo;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ItemStateFactory isf;
    private final HierarchyManager hierarchyManager;
    private final CacheBehaviour cacheBehaviour;
    private final IdFactory idFactory;
    private final NamespaceRegistryImpl nsRegistry;
    private final NodeTypeRegistryImpl ntRegistry;
    private final ItemDefinitionProvider definitionProvider;
    private final Sync updateSync = new Mutex();
    private final Thread changeFeed;
    private final Set listeners = new HashSet();
    private Subscription subscription;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.WorkspaceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public WorkspaceManager(RepositoryService service, SessionInfo sessionInfo, CacheBehaviour cacheBehaviour, int pollTimeout, boolean enableObservation) throws RepositoryException {
        this.service = service;
        this.sessionInfo = sessionInfo;
        this.cacheBehaviour = cacheBehaviour;
        this.nameFactory = service.getNameFactory();
        this.pathFactory = service.getPathFactory();
        this.idFactory = service.getIdFactory();
        this.nsRegistry = new NamespaceRegistryImpl(this);
        this.ntRegistry = this.createNodeTypeRegistry(this.nsRegistry);
        this.changeFeed = this.createChangeFeed(pollTimeout, enableObservation);
        this.definitionProvider = this.createDefinitionProvider(this.getEffectiveNodeTypeProvider());
        TransientItemStateFactory stateFactory = this.createItemStateFactory();
        this.isf = stateFactory;
        this.hierarchyManager = this.createHierarchyManager(stateFactory, this.idFactory);
        this.createHierarchyListener(this.hierarchyManager);
    }

    public NamespaceRegistryImpl getNamespaceRegistryImpl() {
        return this.nsRegistry;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntRegistry;
    }

    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.definitionProvider;
    }

    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.ntRegistry;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierarchyManager;
    }

    public String[] getWorkspaceNames() throws RepositoryException {
        return this.service.getWorkspaceNames(this.sessionInfo);
    }

    public IdFactory getIdFactory() throws RepositoryException {
        return this.idFactory;
    }

    public NameFactory getNameFactory() throws RepositoryException {
        return this.nameFactory;
    }

    public PathFactory getPathFactory() throws RepositoryException {
        return this.pathFactory;
    }

    public ItemStateFactory getItemStateFactory() {
        return this.isf;
    }

    public LockInfo getLockInfo(NodeId nodeId) throws RepositoryException {
        return this.service.getLockInfo(this.sessionInfo, nodeId);
    }

    public String[] getLockTokens() {
        return this.sessionInfo.getLockTokens();
    }

    public void addLockToken(String lt) throws LockException, RepositoryException {
        this.sessionInfo.addLockToken(lt);
    }

    public void removeLockToken(String lt) throws LockException, RepositoryException {
        String[] tokems = this.sessionInfo.getLockTokens();
        int i = 0;
        while (i < tokems.length) {
            if (tokems[i].equals(lt)) {
                this.sessionInfo.removeLockToken(lt);
                return;
            }
            ++i;
        }
        throw new RepositoryException("Unable to remove locktoken '" + lt + "' from Session.");
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return this.service.getSupportedQueryLanguages(this.sessionInfo);
    }

    public void checkQueryStatement(String statement, String language, Map namespaces) throws InvalidQueryException, RepositoryException {
        this.service.checkQueryStatement(this.sessionInfo, statement, language, namespaces);
    }

    public QueryInfo executeQuery(String statement, String language, Map namespaces) throws RepositoryException {
        return this.service.executeQuery(this.sessionInfo, statement, language, namespaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(InternalEventListener listener) throws RepositoryException {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            EventFilter[] filters = WorkspaceManager.getEventFilters(this.listeners);
            if (this.listeners.size() == 1) {
                this.subscription = this.service.createSubscription(this.sessionInfo, filters);
            } else {
                this.service.updateEventFilters(this.subscription, filters);
            }
            this.listeners.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventFilters() throws RepositoryException {
        Set set = this.listeners;
        synchronized (set) {
            this.service.updateEventFilters(this.subscription, WorkspaceManager.getEventFilters(this.listeners));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(InternalEventListener listener) throws RepositoryException {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.service.dispose(this.subscription);
                this.subscription = null;
            } else {
                this.service.updateEventFilters(this.subscription, WorkspaceManager.getEventFilters(this.listeners));
            }
        }
    }

    public EventFilter createEventFilter(int eventTypes, Path path, boolean isDeep, String[] uuids, Name[] nodeTypes, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.service.createEventFilter(this.sessionInfo, eventTypes, path, isDeep, uuids, nodeTypes, noLocal);
    }

    private static EventFilter[] getEventFilters(Collection listeners) {
        ArrayList filters = new ArrayList();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            InternalEventListener listener = (InternalEventListener)it.next();
            filters.addAll(listener.getEventFilters());
        }
        return filters.toArray(new EventFilter[filters.size()]);
    }

    private TransientItemStateFactory createItemStateFactory() {
        WorkspaceItemStateFactory isf = new WorkspaceItemStateFactory(this.service, this.sessionInfo, this.getItemDefinitionProvider());
        TransientISFactory tisf = new TransientISFactory(isf, this.getItemDefinitionProvider());
        return tisf;
    }

    private HierarchyManager createHierarchyManager(TransientItemStateFactory tisf, IdFactory idFactory) throws RepositoryException {
        return new HierarchyManagerImpl(tisf, idFactory, this.getPathFactory());
    }

    private InternalEventListener createHierarchyListener(HierarchyManager hierarchyMgr) {
        HierarchyEventListener listener = new HierarchyEventListener(this, hierarchyMgr, this.cacheBehaviour);
        return listener;
    }

    private NodeTypeRegistryImpl createNodeTypeRegistry(NamespaceRegistry nsRegistry) {
        NodeTypeStorage ntst = new NodeTypeStorage(){

            public Iterator getAllDefinitions() throws RepositoryException {
                return WorkspaceManager.this.service.getQNodeTypeDefinitions(WorkspaceManager.this.sessionInfo);
            }

            public Iterator getDefinitions(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                return WorkspaceManager.this.service.getQNodeTypeDefinitions(WorkspaceManager.this.sessionInfo, nodeTypeNames);
            }

            public void registerNodeTypes(QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
                throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
            }

            public void reregisterNodeTypes(QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
                throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
            }

            public void unregisterNodeTypes(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
            }
        };
        NodeTypeCache ntCache = NodeTypeCache.getInstance(this.service, this.sessionInfo.getUserID());
        ntst = ntCache.wrap(ntst);
        return NodeTypeRegistryImpl.create(ntst, nsRegistry);
    }

    private ItemDefinitionProvider createDefinitionProvider(EffectiveNodeTypeProvider entProvider) {
        return new ItemDefinitionProviderImpl(entProvider, this.service, this.sessionInfo);
    }

    private Thread createChangeFeed(int pollTimeout, boolean enableObservation) {
        Thread t = null;
        if (enableObservation) {
            t = new Thread(new ChangePolling(pollTimeout));
            t.setName("Change Polling");
            t.setDaemon(true);
            t.start();
        }
        return t;
    }

    public void execute(Operation operation) throws RepositoryException {
        try {
            this.updateSync.acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException((Throwable)e);
        }
        try {
            new OperationVisitorImpl(this.sessionInfo).execute(operation);
            operation.persisted();
        }
        finally {
            this.updateSync.release();
        }
    }

    public void execute(ChangeLog changes) throws RepositoryException {
        try {
            this.updateSync.acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException((Throwable)e);
        }
        try {
            new OperationVisitorImpl(this.sessionInfo).execute(changes);
            changes.persisted();
        }
        finally {
            this.updateSync.release();
        }
    }

    public synchronized void dispose() {
        block7: {
            try {
                try {
                    this.updateSync.acquire();
                    if (this.changeFeed != null) {
                        this.changeFeed.interrupt();
                    }
                    this.hierarchyManager.dispose();
                    if (this.subscription != null) {
                        this.service.dispose(this.subscription);
                    }
                    this.service.dispose(this.sessionInfo);
                }
                catch (Exception e) {
                    log.warn("Exception while disposing WorkspaceManager: " + e);
                    this.updateSync.release();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.updateSync.release();
                throw throwable;
            }
            this.updateSync.release();
        }
        this.ntRegistry.dispose();
    }

    public boolean isGranted(NodeState parentState, Path relPath, String[] actions) throws ItemNotFoundException, RepositoryException {
        if (parentState.getStatus() == 4) {
            return true;
        }
        NodeId id = this.idFactory.createNodeId((NodeId)parentState.getWorkspaceId(), relPath);
        return this.service.isGranted(this.sessionInfo, (ItemId)id, actions);
    }

    public boolean isGranted(ItemState itemState, String[] actions) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), actions);
    }

    public boolean canRead(ItemState itemState) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), AccessManager.READ);
    }

    public boolean canRemove(ItemState itemState) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), AccessManager.REMOVE);
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        String[] wspNames = this.getWorkspaceNames();
        int i = 0;
        while (i < wspNames.length) {
            if (wspNames[i].equals(workspaceName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Map getRegisteredNamespaces() throws RepositoryException {
        return this.service.getRegisteredNamespaces(this.sessionInfo);
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        return this.service.getNamespacePrefix(this.sessionInfo, uri);
    }

    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        return this.service.getNamespaceURI(this.sessionInfo, prefix);
    }

    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.service.registerNamespace(this.sessionInfo, prefix, uri);
    }

    public void unregisterNamespace(String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.service.unregisterNamespace(this.sessionInfo, uri);
    }

    private void onEventReceived(EventBundle[] eventBundles, InternalEventListener[] lstnrs) throws InterruptedException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("received {} event bundles.", (Object)new Integer(eventBundles.length));
            i = 0;
            while (i < eventBundles.length) {
                log.debug("IsLocal:  {}", (Object)eventBundles[i].isLocal());
                Iterator it = eventBundles[i].getEvents();
                while (it.hasNext()) {
                    String type;
                    Event e = (Event)it.next();
                    switch (e.getType()) {
                        case 1: {
                            type = "NodeAdded";
                            break;
                        }
                        case 2: {
                            type = "NodeRemoved";
                            break;
                        }
                        case 4: {
                            type = "PropertyAdded";
                            break;
                        }
                        case 16: {
                            type = "PropertyChanged";
                            break;
                        }
                        case 8: {
                            type = "PropertyRemoved";
                            break;
                        }
                        default: {
                            type = "Unknown";
                        }
                    }
                    log.debug("  {}; {}", (Object)e.getPath(), (Object)type);
                }
                ++i;
            }
        }
        this.updateSync.acquire();
        try {
            i = 0;
            while (i < eventBundles.length) {
                int j = 0;
                while (j < lstnrs.length) {
                    lstnrs[j].onEvent(eventBundles[i]);
                    ++j;
                }
                ++i;
            }
        }
        finally {
            this.updateSync.release();
        }
    }

    private final class ChangePolling
    implements Runnable {
        private final int pollTimeout;

        private ChangePolling(int pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Subscription subscr;
                    InternalEventListener[] iel;
                    Set set = WorkspaceManager.this.listeners;
                    synchronized (set) {
                        while (WorkspaceManager.this.listeners.isEmpty()) {
                            WorkspaceManager.this.listeners.wait();
                        }
                        iel = WorkspaceManager.this.listeners.toArray(new InternalEventListener[0]);
                        subscr = WorkspaceManager.this.subscription;
                    }
                    log.debug("calling getEvents() (Workspace={})", (Object)WorkspaceManager.this.sessionInfo.getWorkspaceName());
                    EventBundle[] bundles = WorkspaceManager.this.service.getEvents(subscr, (long)this.pollTimeout);
                    log.debug("returned from getEvents() (Workspace={})", (Object)WorkspaceManager.this.sessionInfo.getWorkspaceName());
                    if (Thread.interrupted()) {
                        log.debug("Thread interrupted, terminating...");
                        break;
                    }
                    if (bundles.length <= 0) continue;
                    WorkspaceManager.this.onEventReceived(bundles, iel);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    log.error("SPI implementation does not support observation: " + (Object)((Object)e));
                    break;
                }
                catch (RepositoryException e) {
                    log.info("Workspace=" + WorkspaceManager.this.sessionInfo.getWorkspaceName() + ": Exception while retrieving event bundles: " + (Object)((Object)e));
                    log.debug("Dump:", (Throwable)e);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    log.warn("Exception in event polling thread: " + e);
                    log.debug("Dump:", (Throwable)e);
                }
            }
        }
    }

    private final class OperationVisitorImpl
    implements OperationVisitor {
        private final SessionInfo sessionInfo;
        private Batch batch;

        private OperationVisitorImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        private void execute(ChangeLog changeLog) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
            RepositoryException ex;
            block18: {
                ex = null;
                try {
                    try {
                        ItemState target = changeLog.getTarget();
                        this.batch = WorkspaceManager.this.service.createBatch(this.sessionInfo, target.getId());
                        Iterator it = changeLog.getOperations().iterator();
                        while (it.hasNext()) {
                            Operation op = (Operation)it.next();
                            log.debug("executing " + op.getName());
                            op.accept(this);
                        }
                    }
                    catch (RepositoryException e) {
                        block19: {
                            ex = e;
                            if (this.batch == null) break block18;
                            try {
                                WorkspaceManager.this.service.submit(this.batch);
                            }
                            catch (RepositoryException e2) {
                                if (ex == null) {
                                    ex = e2;
                                    break block19;
                                }
                                log.warn("Exception submitting batch", (Throwable)e2);
                            }
                        }
                        this.batch = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (this.batch != null) {
                        block20: {
                            try {
                                WorkspaceManager.this.service.submit(this.batch);
                            }
                            catch (RepositoryException e) {
                                if (ex == null) {
                                    ex = e;
                                    break block20;
                                }
                                log.warn("Exception submitting batch", (Throwable)e);
                            }
                        }
                        this.batch = null;
                    }
                    throw throwable;
                }
                if (this.batch != null) {
                    try {
                        WorkspaceManager.this.service.submit(this.batch);
                    }
                    catch (RepositoryException e) {
                        if (ex == null) {
                            ex = e;
                        }
                        log.warn("Exception submitting batch", (Throwable)e);
                    }
                    this.batch = null;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        private void execute(Operation workspaceOperation) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
            log.debug("executing " + workspaceOperation.getName());
            workspaceOperation.accept(this);
        }

        public void visit(AddNode operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            this.batch.addNode(parentId, operation.getNodeName(), operation.getNodeTypeName(), operation.getUuid());
        }

        public void visit(AddProperty operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            Name propertyName = operation.getPropertyName();
            if (operation.isMultiValued()) {
                this.batch.addProperty(parentId, propertyName, operation.getValues());
            } else {
                QValue value = operation.getValues()[0];
                this.batch.addProperty(parentId, propertyName, value);
            }
        }

        public void visit(Clone operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId destParentId = operation.getDestinationParentId();
            WorkspaceManager.this.service.clone(this.sessionInfo, operation.getWorkspaceName(), nId, destParentId, operation.getDestinationName(), operation.isRemoveExisting());
        }

        public void visit(Copy operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId destParentId = operation.getDestinationParentId();
            WorkspaceManager.this.service.copy(this.sessionInfo, operation.getWorkspaceName(), nId, destParentId, operation.getDestinationName());
        }

        public void visit(Move operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId moveId = operation.getSourceId();
            NodeId destParentId = operation.getDestinationParentId();
            if (this.batch == null) {
                WorkspaceManager.this.service.move(this.sessionInfo, moveId, destParentId, operation.getDestinationName());
            } else {
                this.batch.move(moveId, destParentId, operation.getDestinationName());
            }
        }

        public void visit(Update operation) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            WorkspaceManager.this.service.update(this.sessionInfo, nId, operation.getSourceWorkspaceName());
        }

        public void visit(Remove operation) throws RepositoryException {
            this.batch.remove(operation.getRemoveId());
        }

        public void visit(SetMixin operation) throws RepositoryException {
            this.batch.setMixins(operation.getNodeId(), operation.getMixinNames());
        }

        public void visit(SetPropertyValue operation) throws RepositoryException {
            PropertyId id = operation.getPropertyId();
            if (operation.isMultiValued()) {
                this.batch.setValue(id, operation.getValues());
            } else {
                this.batch.setValue(id, operation.getValues()[0]);
            }
        }

        public void visit(ReorderNodes operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            NodeId insertId = operation.getInsertId();
            NodeId beforeId = operation.getBeforeId();
            this.batch.reorderNodes(parentId, insertId, beforeId);
        }

        public void visit(Checkout operation) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
            WorkspaceManager.this.service.checkout(this.sessionInfo, operation.getNodeId());
        }

        public void visit(Checkin operation) throws UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            NodeId newId = WorkspaceManager.this.service.checkin(this.sessionInfo, operation.getNodeId());
            operation.setNewVersionId(newId);
        }

        public void visit(Restore operation) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            if (nId == null) {
                WorkspaceManager.this.service.restore(this.sessionInfo, operation.getVersionIds(), operation.removeExisting());
            } else {
                Path relPath = operation.getRelativePath();
                NodeId targetId = relPath != null ? WorkspaceManager.this.idFactory.createNodeId(nId, relPath) : nId;
                NodeId versionId = operation.getVersionIds()[0];
                WorkspaceManager.this.service.restore(this.sessionInfo, targetId, versionId, operation.removeExisting());
            }
        }

        public void visit(Merge operation) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            Iterator failed = WorkspaceManager.this.service.merge(this.sessionInfo, nId, operation.getSourceWorkspaceName(), operation.bestEffort());
            operation.setFailedIds(failed);
        }

        public void visit(ResolveMergeConflict operation) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId[] mergedFailedIds = operation.getMergeFailedIds();
            NodeId[] predecessorIds = operation.getPredecessorIds();
            WorkspaceManager.this.service.resolveMergeConflict(this.sessionInfo, nId, mergedFailedIds, predecessorIds);
        }

        public void visit(LockOperation operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            LockInfo lInfo = WorkspaceManager.this.service.lock(this.sessionInfo, operation.getNodeId(), operation.isDeep(), operation.isSessionScoped(), operation.getTimeoutHint(), operation.getOwnerHint());
            operation.setLockInfo(lInfo);
        }

        public void visit(LockRefresh operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            WorkspaceManager.this.service.refreshLock(this.sessionInfo, operation.getNodeId());
        }

        public void visit(LockRelease operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            WorkspaceManager.this.service.unlock(this.sessionInfo, operation.getNodeId());
        }

        public void visit(AddLabel operation) throws VersionException, RepositoryException {
            NodeId vhId = operation.getVersionHistoryId();
            NodeId vId = operation.getVersionId();
            WorkspaceManager.this.service.addVersionLabel(this.sessionInfo, vhId, vId, operation.getLabel(), operation.moveLabel());
        }

        public void visit(RemoveLabel operation) throws VersionException, RepositoryException {
            NodeId vhId = operation.getVersionHistoryId();
            NodeId vId = operation.getVersionId();
            WorkspaceManager.this.service.removeVersionLabel(this.sessionInfo, vhId, vId, operation.getLabel());
        }

        public void visit(RemoveVersion operation) throws VersionException, AccessDeniedException, ReferentialIntegrityException, RepositoryException {
            NodeId versionId = (NodeId)operation.getRemoveId();
            NodeState vhState = operation.getParentState();
            WorkspaceManager.this.service.removeVersion(this.sessionInfo, (NodeId)vhState.getWorkspaceId(), versionId);
        }

        public void visit(WorkspaceImport operation) throws RepositoryException {
            WorkspaceManager.this.service.importXml(this.sessionInfo, operation.getNodeId(), operation.getXmlStream(), operation.getUuidBehaviour());
        }
    }
}

