/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.jcr2spi.hierarchy.ChildPropertyEntries;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildPropertyEntriesImpl
implements ChildPropertyEntries {
    private static Logger log;
    private final Map properties = new HashMap();
    private final NodeEntry parent;
    private final EntryFactory factory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.hierarchy.ChildPropertyEntriesImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    ChildPropertyEntriesImpl(NodeEntry parent, EntryFactory factory) {
        this.parent = parent;
        this.factory = factory;
    }

    public boolean contains(Name propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public PropertyEntry get(Name propertyName) {
        Object ref = this.properties.get(propertyName);
        if (ref == null) {
            return null;
        }
        PropertyEntry entry = (PropertyEntry)((Reference)ref).get();
        if (entry == null) {
            entry = this.factory.createPropertyEntry(this.parent, propertyName);
            this.add(entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getPropertyEntries() {
        Map map = this.properties;
        synchronized (map) {
            HashSet<PropertyEntry> entries = new HashSet<PropertyEntry>(this.properties.size());
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Name propName = (Name)it.next();
                entries.add(this.get(propName));
            }
            return Collections.unmodifiableCollection(entries);
        }
    }

    public Collection getPropertyNames() {
        return Collections.unmodifiableCollection(this.properties.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PropertyEntry propertyEntry) {
        Map map = this.properties;
        synchronized (map) {
            SoftReference<PropertyEntry> ref = new SoftReference<PropertyEntry>(propertyEntry);
            this.properties.put(propertyEntry.getName(), ref);
        }
    }

    public void addAll(Collection propertyEntries) {
        Iterator it = propertyEntries.iterator();
        while (it.hasNext()) {
            Object pe = it.next();
            if (!(pe instanceof PropertyEntry)) continue;
            this.add((PropertyEntry)pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(PropertyEntry propertyEntry) {
        Map map = this.properties;
        synchronized (map) {
            block4: {
                Name pName = propertyEntry.getName();
                PropertyEntry pe = this.get(pName);
                if (pe != propertyEntry) break block4;
                this.properties.remove(pName);
                return true;
            }
            return false;
        }
    }
}

