/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntryImpl;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryFactory {
    private static Logger log;
    private final IdFactory idFactory;
    private final PathFactory pathFactory;
    private final NodeEntry rootEntry;
    private final NodeEntryListener listener;
    private final TransientItemStateFactory isf;
    private NamePathResolver resolver;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public EntryFactory(TransientItemStateFactory isf, IdFactory idFactory, NodeEntryListener listener, PathFactory pathFactory) {
        this.idFactory = idFactory;
        this.pathFactory = pathFactory;
        this.isf = isf;
        this.listener = listener;
        this.rootEntry = NodeEntryImpl.createRootEntry(this);
    }

    public NodeEntry createRootEntry() {
        return this.rootEntry;
    }

    public NodeEntry createNodeEntry(NodeEntry parent, Name qName, String uniqueId) {
        if (!(parent instanceof NodeEntryImpl)) {
            throw new IllegalArgumentException();
        }
        return NodeEntryImpl.createNodeEntry((NodeEntryImpl)parent, qName, uniqueId, this);
    }

    public PropertyEntry createPropertyEntry(NodeEntry parent, Name qName) {
        if (!(parent instanceof NodeEntryImpl)) {
            throw new IllegalArgumentException();
        }
        return PropertyEntryImpl.create((NodeEntryImpl)parent, qName, this);
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public TransientItemStateFactory getItemStateFactory() {
        return this.isf;
    }

    public void notifyEntryCreated(NodeEntry entry) {
        this.listener.entryCreated(entry);
    }

    public void notifyIdChange(NodeEntry entry, String previousUniqueID) {
        this.listener.uniqueIdChanged(entry, previousUniqueID);
    }

    void setResolver(NamePathResolver resolver) {
        this.resolver = resolver;
    }

    String saveGetJCRPath(Path path) {
        if (this.resolver == null) {
            return path.toString();
        }
        return LogUtil.safeGetJCRPath(path, (PathResolver)this.resolver);
    }

    public static interface NodeEntryListener {
        public void entryCreated(NodeEntry var1);

        public void uniqueIdChanged(NodeEntry var1, String var2);
    }
}

