/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.observation.InternalEventListener;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyEventListener
implements InternalEventListener {
    private static Logger log;
    private final HierarchyManager hierarchyMgr;
    private final Collection eventFilter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public HierarchyEventListener(WorkspaceManager wspManager, HierarchyManager hierarchyMgr, CacheBehaviour cacheBehaviour) {
        this.hierarchyMgr = hierarchyMgr;
        if (cacheBehaviour == CacheBehaviour.OBSERVATION) {
            EventFilter filter = null;
            try {
                Path root = wspManager.getPathFactory().getRootPath();
                filter = wspManager.createEventFilter(31, root, true, null, null, true);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            this.eventFilter = filter == null ? Collections.EMPTY_LIST : Collections.singletonList(filter);
            try {
                wspManager.addEventListener(this);
            }
            catch (RepositoryException repositoryException) {}
        } else {
            this.eventFilter = Collections.EMPTY_LIST;
        }
    }

    public Collection getEventFilters() {
        return this.eventFilter;
    }

    public void onEvent(EventBundle eventBundle) {
        if (eventBundle.isLocal()) {
            log.debug("Local event bundle -> not processed by HierarchyEventListener.");
            return;
        }
        this.pushEvents(HierarchyEventListener.getEventCollection(eventBundle));
    }

    private void pushEvents(Collection events) {
        Iterator it;
        if (events.isEmpty()) {
            log.debug("Empty event bundle");
            return;
        }
        HashSet<ItemId> removedEvents = new HashSet<ItemId>();
        HashSet<Event> addEvents = new HashSet<Event>();
        Iterator it2 = events.iterator();
        while (it2.hasNext()) {
            Event event = (Event)it2.next();
            int type = event.getType();
            if (type == 2) {
                removedEvents.add(event.getItemId());
                continue;
            }
            if (type != 1 && type != 4) continue;
            addEvents.add(event);
            it2.remove();
        }
        boolean progress = true;
        while (!addEvents.isEmpty() && progress) {
            progress = false;
            it = addEvents.iterator();
            while (it.hasNext()) {
                Event ev = (Event)it.next();
                NodeId parentId = ev.getParentId();
                HierarchyEntry parent = null;
                if (parentId != null && (parent = this.hierarchyMgr.lookup((ItemId)parentId)) == null && ev.getPath() != null && parentId.getUniqueID() != null) {
                    try {
                        Path parentPath = ev.getPath().getAncestor(1);
                        parent = this.hierarchyMgr.lookup(parentPath);
                    }
                    catch (PathNotFoundException e) {
                        log.debug(e.getMessage());
                    }
                }
                if (parent == null || !parent.denotesNode()) continue;
                ((NodeEntry)parent).refresh(ev);
                it.remove();
                progress = true;
            }
        }
        it = events.iterator();
        while (it.hasNext()) {
            NodeEntry parent;
            Event event = (Event)it.next();
            int type = event.getType();
            NodeId parentId = event.getParentId();
            NodeEntry nodeEntry = parent = parentId != null ? (NodeEntry)this.hierarchyMgr.lookup((ItemId)parentId) : null;
            if (type == 2 || type == 8) {
                if (parent == null || removedEvents.contains(parentId)) continue;
                parent.refresh(event);
                continue;
            }
            if (type == 16) {
                if (parent == null) continue;
                parent.refresh(event);
                continue;
            }
            throw new IllegalArgumentException("Invalid event type: " + event.getType());
        }
    }

    private static Collection getEventCollection(EventBundle eventBundle) {
        ArrayList evs = new ArrayList();
        Iterator it = eventBundle.getEvents();
        while (it.hasNext()) {
            evs.add(it.next());
        }
        return evs;
    }
}

