/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntryImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.UniqueIdResolver;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyManagerImpl
implements HierarchyManager {
    private static Logger log;
    private final NodeEntry rootEntry;
    private final UniqueIdResolver uniqueIdResolver;
    private final IdFactory idFactory;
    private NamePathResolver resolver;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public HierarchyManagerImpl(TransientItemStateFactory isf, IdFactory idFactory, PathFactory pathFactory) {
        this.uniqueIdResolver = new UniqueIdResolver(isf);
        this.rootEntry = new EntryFactory(isf, idFactory, this.uniqueIdResolver, pathFactory).createRootEntry();
        this.idFactory = idFactory;
    }

    public void setResolver(NamePathResolver resolver) {
        this.resolver = resolver;
        if (this.rootEntry instanceof HierarchyEntryImpl) {
            ((HierarchyEntryImpl)((Object)this.rootEntry)).factory.setResolver(resolver);
        }
    }

    public void dispose() {
        this.uniqueIdResolver.dispose();
    }

    public NodeEntry getRootEntry() {
        return this.rootEntry;
    }

    public HierarchyEntry lookup(ItemId workspaceItemId) {
        String uniqueID = workspaceItemId.getUniqueID();
        if (uniqueID == null) {
            return this.rootEntry.lookupDeepEntry(workspaceItemId.getPath());
        }
        NodeEntry nEntry = this.uniqueIdResolver.lookup(uniqueID);
        Path path = workspaceItemId.getPath();
        if (path == null) {
            return nEntry;
        }
        return nEntry.lookupDeepEntry(path);
    }

    public HierarchyEntry lookup(Path workspacePath) {
        return this.rootEntry.lookupDeepEntry(workspacePath);
    }

    public NodeEntry getNodeEntry(NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        String uniqueID = nodeId.getUniqueID();
        if (uniqueID == null) {
            return this.getNodeEntry(nodeId.getPath());
        }
        if (nodeId.getPath() == null) {
            NodeEntry nEntry = this.uniqueIdResolver.resolve(nodeId, this.rootEntry);
            return nEntry;
        }
        NodeEntry nEntry = this.uniqueIdResolver.resolve(this.idFactory.createNodeId(uniqueID), this.rootEntry);
        return nEntry.getDeepNodeEntry(nodeId.getPath());
    }

    public NodeEntry getNodeEntry(Path qPath) throws PathNotFoundException, RepositoryException {
        NodeEntry rootEntry = this.getRootEntry();
        if (qPath.denotesRoot()) {
            return rootEntry;
        }
        if (!qPath.isCanonical()) {
            String msg = "Path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        return rootEntry.getDeepNodeEntry(qPath);
    }

    public PropertyEntry getPropertyEntry(PropertyId propertyId) throws ItemNotFoundException, RepositoryException {
        String uniqueID = propertyId.getUniqueID();
        if (uniqueID == null) {
            return this.getPropertyEntry(propertyId.getPath());
        }
        if (propertyId.getPath() == null) {
            throw new ItemNotFoundException("No property found for id " + LogUtil.saveGetIdString((ItemId)propertyId, (PathResolver)this.resolver));
        }
        NodeEntry nEntry = this.uniqueIdResolver.resolve(this.idFactory.createNodeId(uniqueID), this.rootEntry);
        return nEntry.getDeepPropertyEntry(propertyId.getPath());
    }

    public PropertyEntry getPropertyEntry(Path qPath) throws PathNotFoundException, RepositoryException {
        if (qPath.denotesRoot()) {
            throw new PathNotFoundException("The root path never points to a Property.");
        }
        if (!qPath.isCanonical()) {
            String msg = "Path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        return this.getRootEntry().getDeepPropertyEntry(qPath);
    }

    public NodeState getNodeState(Path qPath) throws PathNotFoundException, RepositoryException {
        NodeEntry entry = this.getNodeEntry(qPath);
        try {
            NodeState state = entry.getNodeState();
            if (state.isValid()) {
                return state;
            }
            throw new PathNotFoundException(LogUtil.safeGetJCRPath(qPath, (PathResolver)this.resolver));
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException((Throwable)e);
        }
    }

    public PropertyState getPropertyState(Path qPath) throws PathNotFoundException, RepositoryException {
        PropertyEntry entry = this.getPropertyEntry(qPath);
        try {
            PropertyState state = entry.getPropertyState();
            if (state.isValid()) {
                return state;
            }
            throw new PathNotFoundException(LogUtil.safeGetJCRPath(qPath, (PathResolver)this.resolver));
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException((Throwable)e);
        }
    }

    public int getDepth(HierarchyEntry hierarchyEntry) throws ItemNotFoundException, RepositoryException {
        int depth = 0;
        NodeEntry parentEntry = hierarchyEntry.getParent();
        while (parentEntry != null) {
            ++depth;
            hierarchyEntry = parentEntry;
            parentEntry = hierarchyEntry.getParent();
        }
        return depth;
    }

    public int getRelativeDepth(NodeEntry ancestor, HierarchyEntry descendant) throws ItemNotFoundException, RepositoryException {
        if (ancestor.equals(descendant)) {
            return 0;
        }
        int depth = 1;
        NodeEntry parent = descendant.getParent();
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return depth;
            }
            ++depth;
            descendant = parent;
            parent = descendant.getParent();
        }
        return -1;
    }
}

