/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.spi.Name;

class BitsetENTCacheImpl
implements EffectiveNodeTypeCache {
    private static final int BPW = 64;
    private static final long[] OR_MASK = new long[64];
    private final TreeSet sortedKeys;
    private final HashMap aggregates;
    private final ConcurrentReaderHashMap nameIndex = new ConcurrentReaderHashMap();
    private Name[] names = new Name[1024];

    static {
        int i = 0;
        while (i < 64) {
            BitsetENTCacheImpl.OR_MASK[i] = 1L << i;
            ++i;
        }
    }

    BitsetENTCacheImpl() {
        this.sortedKeys = new TreeSet();
        this.aggregates = new HashMap();
    }

    public EffectiveNodeTypeCache.Key getKey(Name[] ntNames) {
        return new BitsetKey(ntNames, this.nameIndex.size() + ntNames.length);
    }

    public void put(EffectiveNodeType ent) {
        this.put(this.getKey(ent.getMergedNodeTypes()), ent);
    }

    public void put(EffectiveNodeTypeCache.Key key, EffectiveNodeType ent) {
        this.aggregates.put(key, ent);
        this.sortedKeys.add(key);
    }

    public EffectiveNodeTypeCache.Key findBest(EffectiveNodeTypeCache.Key key) {
        if (this.contains(key)) {
            return key;
        }
        Iterator iter = this.sortedKeys.iterator();
        while (iter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)iter.next();
            if (!key.contains(k)) continue;
            return k;
        }
        return null;
    }

    public void invalidate(Name name) {
        ArrayList keys = new ArrayList(this.aggregates.keySet());
        Iterator keysIter = keys.iterator();
        while (keysIter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)keysIter.next();
            EffectiveNodeType ent = this.get(k);
            if (!ent.includesNodeType(name)) continue;
            this.remove(k);
        }
    }

    public boolean contains(EffectiveNodeTypeCache.Key key) {
        return this.aggregates.containsKey(key);
    }

    public EffectiveNodeType get(EffectiveNodeTypeCache.Key key) {
        return (EffectiveNodeType)this.aggregates.get(key);
    }

    public void clear() {
        this.sortedKeys.clear();
        this.aggregates.clear();
        this.nameIndex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBitNumber(Name name) {
        Integer i = (Integer)this.nameIndex.get((Object)name);
        if (i == null) {
            ConcurrentReaderHashMap concurrentReaderHashMap = this.nameIndex;
            synchronized (concurrentReaderHashMap) {
                i = (Integer)this.nameIndex.get((Object)name);
                if (i == null) {
                    int idx = this.nameIndex.size();
                    i = new Integer(idx);
                    this.nameIndex.put((Object)name, (Object)i);
                    if (idx >= this.names.length) {
                        Name[] newNames = new Name[this.names.length * 2];
                        System.arraycopy(this.names, 0, newNames, 0, this.names.length);
                        this.names = newNames;
                    }
                    this.names[idx] = name;
                }
            }
        }
        return i;
    }

    private Name getName(int n) {
        return this.names[n];
    }

    private EffectiveNodeType remove(EffectiveNodeTypeCache.Key key) {
        EffectiveNodeType removed = (EffectiveNodeType)this.aggregates.remove(key);
        if (removed != null) {
            this.sortedKeys.remove(key);
        }
        return removed;
    }

    public Object clone() {
        BitsetENTCacheImpl clone = new BitsetENTCacheImpl();
        clone.sortedKeys.addAll(this.sortedKeys);
        clone.aggregates.putAll(this.aggregates);
        clone.names = new Name[this.names.length];
        System.arraycopy(this.names, 0, clone.names, 0, this.names.length);
        clone.nameIndex.putAll((Map)this.nameIndex);
        return clone;
    }

    public void dump(PrintStream ps) {
        ps.println("EffectiveNodeTypeCache (" + this + ")");
        ps.println();
        ps.println("EffectiveNodeTypes in cache:");
        ps.println();
        Iterator iter = this.sortedKeys.iterator();
        while (iter.hasNext()) {
            EffectiveNodeTypeCache.Key k = (EffectiveNodeTypeCache.Key)iter.next();
            ps.println(k);
        }
    }

    private class BitsetKey
    implements EffectiveNodeTypeCache.Key {
        private final Name[] names;
        private final long[] bits;
        private final int hashCode;

        public BitsetKey(Name[] names, int maxBit) {
            this.names = names;
            this.bits = new long[maxBit / 64 + 1];
            int i = 0;
            while (i < names.length) {
                int n = BitsetENTCacheImpl.this.getBitNumber(names[i]);
                int n2 = n / 64;
                this.bits[n2] = this.bits[n2] | OR_MASK[n % 64];
                ++i;
            }
            this.hashCode = this.calcHashCode();
        }

        private BitsetKey(long[] bits, int numBits) {
            this.bits = bits;
            this.names = new Name[numBits];
            int i = this.nextSetBit(0);
            int j = 0;
            while (i >= 0) {
                this.names[j++] = BitsetENTCacheImpl.this.getName(i);
                i = this.nextSetBit(i + 1);
            }
            this.hashCode = this.calcHashCode();
        }

        private int nextSetBit(int fromIndex) {
            int addr = fromIndex / 64;
            int off = fromIndex % 64;
            while (addr < this.bits.length) {
                if (this.bits[addr] != 0L) {
                    while (off < 64) {
                        if ((this.bits[addr] & OR_MASK[off]) != 0L) {
                            return addr * 64 + off;
                        }
                        ++off;
                    }
                    off = 0;
                }
                ++addr;
            }
            return -1;
        }

        private int bitCount(long val) {
            val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
            val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
            val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
            val += val >>> 8;
            val += val >>> 16;
            return (int)val + (int)(val >>> 32) & 0xFF;
        }

        private int calcHashCode() {
            long h = 1234L;
            int addr = this.bits.length - 1;
            while (addr >= 0 && this.bits[addr] == 0L) {
                --addr;
            }
            while (addr >= 0) {
                h ^= this.bits[addr] * (long)(addr + 1);
                --addr;
            }
            return (int)(h >> 32 ^ h);
        }

        public Name[] getNames() {
            return this.names;
        }

        public boolean contains(EffectiveNodeTypeCache.Key otherKey) {
            BitsetKey other = (BitsetKey)otherKey;
            int len = Math.max(this.bits.length, other.bits.length);
            int i = 0;
            while (i < len) {
                long w2;
                long w1 = i < this.bits.length ? this.bits[i] : 0L;
                long r = (w1 ^ 0xFFFFFFFFFFFFFFFFL) & (w2 = i < other.bits.length ? other.bits[i] : 0L);
                if (r != 0L) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public EffectiveNodeTypeCache.Key subtract(EffectiveNodeTypeCache.Key otherKey) {
            BitsetKey other = (BitsetKey)otherKey;
            int len = Math.max(this.bits.length, other.bits.length);
            long[] newBits = new long[len];
            int numBits = 0;
            int i = 0;
            while (i < len) {
                long w1 = i < this.bits.length ? this.bits[i] : 0L;
                long w2 = i < other.bits.length ? other.bits[i] : 0L;
                newBits[i] = w1 & (w2 ^ 0xFFFFFFFFFFFFFFFFL);
                numBits += this.bitCount(newBits[i]);
                ++i;
            }
            return new BitsetKey(newBits, numBits);
        }

        public int compareTo(Object other) {
            BitsetKey o = (BitsetKey)other;
            int res = o.names.length - this.names.length;
            if (res == 0) {
                int adr = Math.max(this.bits.length, o.bits.length) - 1;
                while (adr >= 0) {
                    long w2;
                    long w1 = adr < this.bits.length ? this.bits[adr] : 0L;
                    long l = w2 = adr < o.bits.length ? o.bits[adr] : 0L;
                    if (w1 != w2) {
                        long h1 = w1 >>> 32;
                        long h2 = w2 >>> 32;
                        if (h1 == h2) {
                            h1 = w1 & 0xFFFFL;
                            h2 = w2 & 0xFFFFL;
                        }
                        return (int)(h2 - h1);
                    }
                    --adr;
                }
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BitsetKey) {
                BitsetKey o = (BitsetKey)obj;
                if (this.names.length != o.names.length) {
                    return false;
                }
                int adr = Math.max(this.bits.length, o.bits.length) - 1;
                while (adr >= 0) {
                    long w2;
                    long w1 = adr < this.bits.length ? this.bits[adr] : 0L;
                    long l = w2 = adr < o.bits.length ? o.bits[adr] : 0L;
                    if (w1 != w2) {
                        return false;
                    }
                    --adr;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("w=");
            buf.append(this.names.length);
            int i = this.nextSetBit(0);
            while (i >= 0) {
                buf.append(", ").append(i).append("=");
                buf.append(BitsetENTCacheImpl.this.getName(i));
                i = this.nextSetBit(i + 1);
            }
            return buf.toString();
        }
    }
}

