/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefinitionValidator {
    private static Logger log;
    private final EffectiveNodeTypeProvider entProvider;
    private final NamespaceRegistry nsRegistry;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.nodetype.DefinitionValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    DefinitionValidator(EffectiveNodeTypeProvider entProvider, NamespaceRegistry nsRegistry) {
        this.entProvider = entProvider;
        this.nsRegistry = nsRegistry;
    }

    public Map validateNodeTypeDefs(Collection ntDefs, Map validatedDefs) throws InvalidNodeTypeDefException, RepositoryException {
        HashMap<Name, QNodeTypeDefinition> tmpMap = new HashMap<Name, QNodeTypeDefinition>(validatedDefs);
        Iterator it = ntDefs.iterator();
        while (it.hasNext()) {
            QNodeTypeDefinition ntd = (QNodeTypeDefinition)it.next();
            tmpMap.put(ntd.getName(), ntd);
        }
        HashMap<QNodeTypeDefinition, EffectiveNodeType> ntMap = new HashMap<QNodeTypeDefinition, EffectiveNodeType>();
        ArrayList list = new ArrayList(ntDefs);
        int count = -1;
        while (list.size() > 0 && count != 0) {
            count = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iterator.next();
                Collection dependencies = ntd.getDependencies();
                if (!tmpMap.keySet().containsAll(dependencies)) continue;
                EffectiveNodeType ent = this.validateNodeTypeDef(ntd, tmpMap);
                ntMap.put(ntd, ent);
                iterator.remove();
                ++count;
            }
        }
        if (list.size() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("the following node types could not be registered because of unresolvable dependencies: ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                msg.append(((QNodeTypeDefinition)iterator.next()).getName());
                msg.append(" ");
            }
            log.error(msg.toString());
            throw new InvalidNodeTypeDefException(msg.toString());
        }
        return ntMap;
    }

    public EffectiveNodeType validateNodeTypeDef(QNodeTypeDefinition ntDef, Map validatedDefs) throws InvalidNodeTypeDefException, RepositoryException {
        String msg;
        Name name;
        EffectiveNodeType ent;
        block44: {
            ent = null;
            name = ntDef.getName();
            if (name == null) {
                String msg2 = "no name specified";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            this.checkNamespace(name);
            Name[] supertypes = ntDef.getSupertypes();
            if (supertypes.length > 0) {
                int i = 0;
                while (i < supertypes.length) {
                    this.checkNamespace(supertypes[i]);
                    if (name.equals(supertypes[i])) {
                        String msg3 = "[" + name + "] invalid supertype: " + supertypes[i] + " (infinite recursion))";
                        log.debug(msg3);
                        throw new InvalidNodeTypeDefException(msg3);
                    }
                    if (!validatedDefs.containsKey(supertypes[i])) {
                        String msg4 = "[" + name + "] invalid supertype: " + supertypes[i];
                        log.debug(msg4);
                        throw new InvalidNodeTypeDefException(msg4);
                    }
                    ++i;
                }
                Stack<Name> inheritanceChain = new Stack<Name>();
                inheritanceChain.push(name);
                this.checkForCircularInheritance(supertypes, inheritanceChain, validatedDefs);
            }
            if (supertypes.length > 0) {
                try {
                    EffectiveNodeType est = this.entProvider.getEffectiveNodeType(supertypes, validatedDefs);
                    if (!(ntDef.isMixin() || NameConstants.NT_BASE.equals(ntDef.getName()) || est.includesNodeType(NameConstants.NT_BASE))) {
                        String msg5 = "[" + name + "] all primary node types except" + " nt:base itself must be (directly or indirectly) derived from nt:base";
                        log.debug(msg5);
                        throw new InvalidNodeTypeDefException(msg5);
                    }
                    break block44;
                }
                catch (ConstraintViolationException e) {
                    String msg6 = "[" + name + "] failed to validate supertypes";
                    log.debug(msg6);
                    throw new InvalidNodeTypeDefException(msg6, (Throwable)e);
                }
                catch (NoSuchNodeTypeException e) {
                    String msg7 = "[" + name + "] failed to validate supertypes";
                    log.debug(msg7);
                    throw new InvalidNodeTypeDefException(msg7, (Throwable)e);
                }
            }
            if (!ntDef.isMixin() && !NameConstants.NT_BASE.equals(ntDef.getName())) {
                String msg8 = "[" + name + "] all primary node types except nt:base itself must be (directly or indirectly) derived from nt:base";
                log.debug(msg8);
                throw new InvalidNodeTypeDefException(msg8);
            }
        }
        this.checkNamespace(ntDef.getPrimaryItemName());
        QPropertyDefinition[] pda = ntDef.getPropertyDefs();
        int i = 0;
        while (i < pda.length) {
            QPropertyDefinition pd = pda[i];
            if (!name.equals(pd.getDeclaringNodeType())) {
                msg = "[" + name + "#" + pd.getName() + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            this.checkNamespace(pd.getName());
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a type";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            QValue[] defVals = pd.getDefaultValues();
            ValueConstraint.checkValueConstraints((QPropertyDefinition)pd, (QValue[])defVals);
            String[] constraints = pd.getValueConstraints();
            if (constraints != null && constraints.length > 0 && pd.getRequiredType() == 9) {
                int j = 0;
                while (j < constraints.length) {
                    Name ntName = NameFactoryImpl.getInstance().create(constraints[j]);
                    if (!name.equals(ntName) && !validatedDefs.containsKey(ntName)) {
                        String msg9 = "[" + name + "#" + pd.getName() + "] invalid REFERENCE value constraint '" + ntName + "' (unknown node type)";
                        log.debug(msg9);
                        throw new InvalidNodeTypeDefException(msg9);
                    }
                    ++j;
                }
            }
            ++i;
        }
        QNodeDefinition[] cnda = ntDef.getChildNodeDefs();
        int i2 = 0;
        while (i2 < cnda.length) {
            Name[] reqTypes;
            String msg10;
            QNodeDefinition cnd = cnda[i2];
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg10 = "[" + name + "#" + cnd.getName() + "] invalid declaring node type specified";
                log.debug(msg10);
                throw new InvalidNodeTypeDefException(msg10);
            }
            this.checkNamespace(cnd.getName());
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg10 = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a name";
                log.debug(msg10);
                throw new InvalidNodeTypeDefException(msg10);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg10 = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg10);
                throw new InvalidNodeTypeDefException(msg10);
            }
            Name dpt = cnd.getDefaultPrimaryType();
            this.checkNamespace(dpt);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !validatedDefs.containsKey(dpt)) {
                    String msg11 = "[" + name + "#" + cnd.getName() + "] invalid default primary type '" + dpt + "'";
                    log.debug(msg11);
                    throw new InvalidNodeTypeDefException(msg11);
                }
                try {
                    defaultENT = !referenceToSelf ? this.entProvider.getEffectiveNodeType(new Name[]{dpt}, validatedDefs) : (ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs));
                    if (cnd.isAutoCreated()) {
                        Stack<Name> definingNTs = new Stack<Name>();
                        definingNTs.push(name);
                        this.checkForCircularNodeAutoCreation(defaultENT, definingNTs, validatedDefs);
                    }
                }
                catch (ConstraintViolationException e) {
                    String msg12 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg12);
                    throw new InvalidNodeTypeDefException(msg12, (Throwable)e);
                }
                catch (NoSuchNodeTypeException e) {
                    String msg13 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefException(msg13, (Throwable)e);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) != null && reqTypes.length > 0) {
                int n = 0;
                while (n < reqTypes.length) {
                    Name rpt = reqTypes[n];
                    this.checkNamespace(rpt);
                    referenceToSelf = false;
                    if (name.equals(rpt)) {
                        referenceToSelf = true;
                    }
                    if (!name.equals(rpt) && !validatedDefs.containsKey(rpt)) {
                        String msg14 = "[" + name + "#" + cnd.getName() + "] invalid required primary type: " + rpt;
                        log.debug(msg14);
                        throw new InvalidNodeTypeDefException(msg14);
                    }
                    if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                        String msg15 = "[" + name + "#" + cnd.getName() + "] default primary type does not satisfy required primary type constraint " + rpt;
                        log.debug(msg15);
                        throw new InvalidNodeTypeDefException(msg15);
                    }
                    try {
                        if (!referenceToSelf) {
                            this.entProvider.getEffectiveNodeType(new Name[]{rpt}, validatedDefs);
                        } else if (ent == null) {
                            ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs);
                        }
                    }
                    catch (ConstraintViolationException e) {
                        String msg16 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                        log.debug(msg16);
                        throw new InvalidNodeTypeDefException(msg16, (Throwable)e);
                    }
                    catch (NoSuchNodeTypeException e) {
                        String msg17 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                        log.debug(msg17);
                        throw new InvalidNodeTypeDefException(msg17, (Throwable)e);
                    }
                    ++n;
                }
            }
            ++i2;
        }
        if (ent == null) {
            try {
                ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs);
            }
            catch (ConstraintViolationException e) {
                msg = "[" + name + "] failed to resolve node type definition";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, (Throwable)e);
            }
            catch (NoSuchNodeTypeException e) {
                msg = "[" + name + "] failed to resolve node type definition";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, (Throwable)e);
            }
        }
        return ent;
    }

    private void checkForCircularInheritance(Name[] supertypes, Stack inheritanceChain, Map ntdMap) throws InvalidNodeTypeDefException, RepositoryException {
        int i = 0;
        while (i < supertypes.length) {
            Name stName = supertypes[i];
            int pos = inheritanceChain.lastIndexOf(stName);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < inheritanceChain.size()) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                    ++j;
                }
                buf.append("--> ");
                buf.append(stName);
                throw new InvalidNodeTypeDefException("circular inheritance detected: " + buf.toString());
            }
            if (ntdMap.containsKey(stName)) {
                Name[] sta = ((QNodeTypeDefinition)ntdMap.get(stName)).getSupertypes();
                if (sta.length > 0) {
                    inheritanceChain.push(stName);
                    this.checkForCircularInheritance(sta, inheritanceChain, ntdMap);
                    inheritanceChain.pop();
                }
            } else {
                throw new InvalidNodeTypeDefException("Unknown supertype: " + stName);
            }
            ++i;
        }
    }

    private void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack definingParentNTs, Map ntdMap) throws InvalidNodeTypeDefException {
        Name[] childNodeNTs = childNodeENT.getAllNodeTypes();
        int i = 0;
        while (i < childNodeNTs.length) {
            Name nt = childNodeNTs[i];
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < definingParentNTs.size()) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append("node type ");
                    buf.append(definingParentNTs.get(j));
                    buf.append(" defines auto-created child node with default ");
                    ++j;
                }
                buf.append("--> ");
                buf.append("node type ");
                buf.append(nt);
                throw new InvalidNodeTypeDefException("circular node auto-creation detected: " + buf.toString());
            }
            ++i;
        }
        QNodeDefinition[] nodeDefs = childNodeENT.getAutoCreateQNodeDefinitions();
        int i2 = 0;
        while (i2 < nodeDefs.length) {
            Name dnt = nodeDefs[i2].getDefaultPrimaryType();
            Name definingNT = nodeDefs[i2].getDeclaringNodeType();
            try {
                if (dnt != null) {
                    definingParentNTs.push(definingNT);
                    EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(new Name[]{dnt}, ntdMap);
                    this.checkForCircularNodeAutoCreation(ent, definingParentNTs, ntdMap);
                    definingParentNTs.pop();
                }
            }
            catch (NoSuchNodeTypeException e) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDefs[i2].getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, (Throwable)e);
            }
            catch (ConstraintViolationException e) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDefs[i2].getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, (Throwable)e);
            }
            ++i2;
        }
    }

    private void checkNamespace(Name name) throws RepositoryException {
        if (name != null) {
            this.nsRegistry.getPrefix(name.getNamespaceURI());
        }
    }
}

