/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.RepositoryService;

public class NodeTypeCache {
    private static final Map CACHES_PER_SERVICE = new WeakHashMap();
    private final Map nodeTypes = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeTypeCache getInstance(RepositoryService service, String userId) {
        Map caches;
        if (userId == null) {
            return new NodeTypeCache();
        }
        Map map = CACHES_PER_SERVICE;
        synchronized (map) {
            caches = (Map)CACHES_PER_SERVICE.get(service);
            if (caches == null) {
                caches = new ReferenceMap(0, 1);
                CACHES_PER_SERVICE.put(service, caches);
            }
        }
        map = caches;
        synchronized (map) {
            NodeTypeCache cache = (NodeTypeCache)caches.get(userId);
            if (cache == null) {
                cache = new NodeTypeCache();
                caches.put(userId, cache);
            }
            return cache;
        }
    }

    private NodeTypeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAllDefinitions(NodeTypeStorage storage) throws RepositoryException {
        HashMap<Name, QNodeTypeDefinition> allNts = new HashMap<Name, QNodeTypeDefinition>();
        Iterator it = storage.getAllDefinitions();
        while (it.hasNext()) {
            QNodeTypeDefinition def = (QNodeTypeDefinition)it.next();
            allNts.put(def.getName(), def);
        }
        Map map = this.nodeTypes;
        synchronized (map) {
            this.nodeTypes.clear();
            this.nodeTypes.putAll(allNts);
        }
        return allNts.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDefinitions(NodeTypeStorage storage, Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        ArrayList<QNodeTypeDefinition> nts = new ArrayList<QNodeTypeDefinition>();
        ArrayList<Name> missing = null;
        Map map = this.nodeTypes;
        synchronized (map) {
            int i = 0;
            while (i < nodeTypeNames.length) {
                QNodeTypeDefinition def = (QNodeTypeDefinition)this.nodeTypes.get(nodeTypeNames[i]);
                if (def == null) {
                    if (missing == null) {
                        missing = new ArrayList<Name>();
                    }
                    missing.add(nodeTypeNames[i]);
                } else {
                    nts.add(def);
                }
                ++i;
            }
        }
        if (missing != null) {
            Name[] ntNames = missing.toArray(new Name[missing.size()]);
            Iterator it = storage.getDefinitions(ntNames);
            Map map2 = this.nodeTypes;
            synchronized (map2) {
                while (it.hasNext()) {
                    QNodeTypeDefinition def = (QNodeTypeDefinition)it.next();
                    nts.add(def);
                    this.nodeTypes.put(def.getName(), def);
                }
            }
        }
        return nts.iterator();
    }

    public void registerNodeTypes(NodeTypeStorage storage, QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
        throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
    }

    public void reregisterNodeTypes(NodeTypeStorage storage, QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
        throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
    }

    public void unregisterNodeTypes(NodeTypeStorage storage, Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        throw new UnsupportedOperationException("NodeType registration not yet defined by the SPI");
    }

    public NodeTypeStorage wrap(final NodeTypeStorage storage) {
        return new NodeTypeStorage(){

            public Iterator getAllDefinitions() throws RepositoryException {
                return NodeTypeCache.this.getAllDefinitions(storage);
            }

            public Iterator getDefinitions(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                return NodeTypeCache.this.getDefinitions(storage, nodeTypeNames);
            }

            public void registerNodeTypes(QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
                NodeTypeCache.this.registerNodeTypes(storage, nodeTypeDefs);
            }

            public void reregisterNodeTypes(QNodeTypeDefinition[] nodeTypeDefs) throws NoSuchNodeTypeException, RepositoryException {
                NodeTypeCache.this.reregisterNodeTypes(storage, nodeTypeDefs);
            }

            public void unregisterNodeTypes(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                NodeTypeCache.this.unregisterNodeTypes(storage, nodeTypeNames);
            }
        };
    }
}

