/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeImpl
implements NodeType {
    private static Logger log;
    private final QNodeTypeDefinition ntd;
    private final EffectiveNodeType ent;
    private final NodeTypeManagerImpl ntMgr;
    private final ManagerProvider mgrProvider;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    NodeTypeImpl(EffectiveNodeType ent, QNodeTypeDefinition ntd, NodeTypeManagerImpl ntMgr, ManagerProvider mgrProvider) {
        this.ent = ent;
        this.ntMgr = ntMgr;
        this.mgrProvider = mgrProvider;
        this.ntd = ntd;
    }

    private NamespaceResolver nsResolver() {
        return this.mgrProvider.getNamespaceResolver();
    }

    private NamePathResolver resolver() {
        return this.mgrProvider.getNamePathResolver();
    }

    private ItemDefinitionProvider definitionProvider() {
        return this.mgrProvider.getItemDefinitionProvider();
    }

    private ValueFactory valueFactory() throws RepositoryException {
        return this.mgrProvider.getJcrValueFactory();
    }

    private QValueFactory qValueFactory() throws RepositoryException {
        return this.mgrProvider.getQValueFactory();
    }

    private QPropertyDefinition getApplicablePropDef(Name propertyName, int type, boolean multiValued) throws RepositoryException {
        return this.definitionProvider().getQPropertyDefinition(this.getQName(), propertyName, type, multiValued);
    }

    public boolean isNodeType(Name nodeTypeName) {
        return this.ent.includesNodeType(nodeTypeName);
    }

    private Name getQName() {
        return this.ntd.getName();
    }

    private static void checkSetPropertyValueConstraints(QPropertyDefinition def, QValue[] values) throws ConstraintViolationException, RepositoryException {
        ValueConstraint.checkValueConstraints((QPropertyDefinition)def, (QValue[])values);
    }

    public String getName() {
        try {
            return this.resolver().getJCRName(this.ntd.getName());
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in node type name", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public String getPrimaryItemName() {
        try {
            Name piName = this.ntd.getPrimaryItemName();
            if (piName != null) {
                return this.resolver().getJCRName(piName);
            }
            return null;
        }
        catch (NamespaceException e) {
            log.error("encountered unregistered namespace in name of primary item", (Throwable)e);
            return this.ntd.getName().toString();
        }
    }

    public boolean isMixin() {
        return this.ntd.isMixin();
    }

    public boolean isNodeType(String nodeTypeName) {
        Name ntName;
        try {
            ntName = this.resolver().getQName(nodeTypeName);
        }
        catch (NamespaceException e) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)e);
            return false;
        }
        catch (NameException e) {
            log.warn("invalid node type name: " + nodeTypeName, (Throwable)e);
            return false;
        }
        return this.isNodeType(ntName);
    }

    public boolean hasOrderableChildNodes() {
        return this.ntd.hasOrderableChildNodes();
    }

    public NodeType[] getSupertypes() {
        Name[] ntNames = this.ent.getInheritedNodeTypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        int i = 0;
        while (i < ntNames.length) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
            ++i;
        }
        return supertypes;
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        QNodeDefinition[] cnda = this.ent.getAllQNodeDefinitions();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        int i = 0;
        while (i < cnda.length) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
            ++i;
        }
        return nodeDefs;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ent.getAllQPropertyDefinitions();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        int i = 0;
        while (i < pda.length) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
            ++i;
        }
        return propDefs;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        QPropertyDefinition[] pda = this.ntd.getPropertyDefs();
        PropertyDefinition[] propDefs = new PropertyDefinition[pda.length];
        int i = 0;
        while (i < pda.length) {
            propDefs[i] = this.ntMgr.getPropertyDefinition(pda[i]);
            ++i;
        }
        return propDefs;
    }

    public NodeType[] getDeclaredSupertypes() {
        Name[] ntNames = this.ntd.getSupertypes();
        NodeType[] supertypes = new NodeType[ntNames.length];
        int i = 0;
        while (i < ntNames.length) {
            try {
                supertypes[i] = this.ntMgr.getNodeType(ntNames[i]);
            }
            catch (NoSuchNodeTypeException e) {
                log.error("undefined supertype", (Throwable)e);
                return new NodeType[0];
            }
            ++i;
        }
        return supertypes;
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        QNodeDefinition[] cnda = this.ntd.getChildNodeDefs();
        NodeDefinition[] nodeDefs = new NodeDefinition[cnda.length];
        int i = 0;
        while (i < cnda.length) {
            nodeDefs[i] = this.ntMgr.getNodeDefinition(cnda[i]);
            ++i;
        }
        return nodeDefs;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        QPropertyDefinition def;
        block9: {
            block8: {
                if (value == null) {
                    return this.canRemoveItem(propertyName);
                }
                Name name = this.resolver().getQName(propertyName);
                try {
                    def = this.getApplicablePropDef(name, value.getType(), false);
                }
                catch (ConstraintViolationException cve) {
                    def = this.getApplicablePropDef(name, 0, false);
                }
                if (!def.isProtected()) break block8;
                return false;
            }
            if (!def.isMultiple()) break block9;
            return false;
        }
        try {
            Value v = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? ValueHelper.convert((Value)value, (int)def.getRequiredType(), (ValueFactory)this.valueFactory()) : value;
            QValue qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.resolver(), (QValueFactory)this.qValueFactory());
            NodeTypeImpl.checkSetPropertyValueConstraints(def, new QValue[]{qValue});
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveItem(propertyName);
        }
        try {
            QPropertyDefinition def;
            Name name = this.resolver().getQName(propertyName);
            int type = 0;
            int i = 0;
            while (true) {
                if (i >= values.length) {
                    try {
                        def = this.getApplicablePropDef(name, type, true);
                    }
                    catch (ConstraintViolationException cve) {
                        def = this.getApplicablePropDef(name, 0, true);
                    }
                    break;
                }
                if (values[i] != null) {
                    if (type == 0) {
                        type = values[i].getType();
                    } else if (type != values[i].getType()) {
                        return false;
                    }
                }
                ++i;
            }
            if (def.isProtected()) {
                return false;
            }
            if (!def.isMultiple()) {
                return false;
            }
            int targetType = def.getRequiredType() != 0 && def.getRequiredType() != type ? def.getRequiredType() : type;
            ArrayList<QValue> list = new ArrayList<QValue>();
            int i2 = 0;
            while (true) {
                if (i2 >= values.length) {
                    QValue[] internalValues = list.toArray(new QValue[list.size()]);
                    NodeTypeImpl.checkSetPropertyValueConstraints(def, internalValues);
                    return true;
                }
                if (values[i2] != null) {
                    Value v = ValueHelper.convert((Value)values[i2], (int)targetType, (ValueFactory)this.valueFactory());
                    QValue qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)this.resolver(), (QValueFactory)this.qValueFactory());
                    list.add(qValue);
                }
                ++i2;
            }
        }
        catch (NameException nameException) {
            return false;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver().getQName(childNodeName), this.definitionProvider());
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            this.ent.checkAddNodeConstraints(this.resolver().getQName(childNodeName), this.resolver().getQName(nodeTypeName), this.definitionProvider());
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        try {
            this.ent.checkRemoveItemConstraints(this.resolver().getQName(itemName));
            return true;
        }
        catch (NameException nameException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }
}

