/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.jcr2spi.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.DefinitionValidator;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.jcr2spi.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidNodeTypeDefException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRegistryImpl
implements Dumpable,
NodeTypeRegistry,
EffectiveNodeTypeProvider {
    private static Logger log;
    private final EffectiveNodeTypeCache entCache;
    private final NodeTypeDefinitionMap registeredNTDefs;
    private final Set propDefs;
    private final Set nodeDefs;
    private final NodeTypeStorage storage;
    private final DefinitionValidator validator;
    private final Map listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public static NodeTypeRegistryImpl create(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        NodeTypeRegistryImpl ntRegistry = new NodeTypeRegistryImpl(storage, nsRegistry);
        return ntRegistry;
    }

    public synchronized void dispose() {
        this.entCache.clear();
        this.registeredNTDefs.clear();
        this.propDefs.clear();
        this.nodeDefs.clear();
        this.listeners.clear();
    }

    private NodeTypeRegistryImpl(NodeTypeStorage storage, NamespaceRegistry nsRegistry) {
        this.storage = storage;
        this.validator = new DefinitionValidator(this, nsRegistry);
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new NodeTypeDefinitionMap();
        this.propDefs = new HashSet();
        this.nodeDefs = new HashSet();
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public Name[] getRegisteredNodeTypes() throws RepositoryException {
        Set qNames = this.registeredNTDefs.keySet();
        return qNames.toArray(new Name[this.registeredNTDefs.size()]);
    }

    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey(nodeTypeName);
    }

    public synchronized EffectiveNodeType registerNodeType(QNodeTypeDefinition ntDef) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.validator.validateNodeTypeDef(ntDef, this.registeredNTDefs);
        this.storage.registerNodeTypes(new QNodeTypeDefinition[]{ntDef});
        this.internalRegister(ntDef, ent);
        this.notifyRegistered(ntDef.getName());
        return ent;
    }

    public synchronized void registerNodeTypes(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        Map defMap = this.validator.validateNodeTypeDefs(ntDefs, this.registeredNTDefs);
        this.storage.registerNodeTypes(ntDefs.toArray(new QNodeTypeDefinition[ntDefs.size()]));
        this.internalRegister(defMap);
        Iterator iter = ntDefs.iterator();
        while (iter.hasNext()) {
            Name ntName = ((QNodeTypeDefinition)iter.next()).getName();
            this.notifyRegistered(ntName);
        }
    }

    public void unregisterNodeType(Name nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        ntNames.add(nodeTypeName);
        this.unregisterNodeTypes(ntNames);
    }

    public synchronized void unregisterNodeTypes(Collection nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        Name ntName;
        Iterator iter = nodeTypeNames.iterator();
        while (iter.hasNext()) {
            ntName = (Name)iter.next();
            Set dependents = this.registeredNTDefs.getDependentNodeTypes(ntName);
            dependents.removeAll(nodeTypeNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            Iterator depIter = dependents.iterator();
            while (depIter.hasNext()) {
                msg.append(depIter.next());
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        this.storage.unregisterNodeTypes(nodeTypeNames.toArray(new Name[nodeTypeNames.size()]));
        this.internalUnregister(nodeTypeNames);
        iter = nodeTypeNames.iterator();
        while (iter.hasNext()) {
            ntName = (Name)iter.next();
            this.notifyUnregistered(ntName);
        }
    }

    public synchronized EffectiveNodeType reregisterNodeType(QNodeTypeDefinition ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (!this.registeredNTDefs.containsKey(name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        EffectiveNodeType ent = this.validator.validateNodeTypeDef(ntd, this.registeredNTDefs);
        this.storage.reregisterNodeTypes(new QNodeTypeDefinition[]{ntd});
        this.internalUnregister(name);
        this.internalRegister(ntd, ent);
        this.notifyReRegistered(name);
        return ent;
    }

    public QNodeTypeDefinition getNodeTypeDefinition(Name nodeTypeName) throws NoSuchNodeTypeException {
        QNodeTypeDefinition def = (QNodeTypeDefinition)this.registeredNTDefs.get(nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException("Nodetype " + nodeTypeName + " doesn't exist");
        }
        return def;
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntName, this.entCache, (Map)this.registeredNTDefs);
    }

    public synchronized EffectiveNodeType getEffectiveNodeType(Name[] ntNames) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, (Map)this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Name[] ntNames, Map ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        return this.getEffectiveNodeType(ntNames, this.entCache, ntdMap);
    }

    public EffectiveNodeType getEffectiveNodeType(QNodeTypeDefinition ntd, Map ntdMap) throws ConstraintViolationException, NoSuchNodeTypeException {
        TreeSet<Name> mergedNodeTypes = new TreeSet<Name>();
        TreeSet inheritedNodeTypes = new TreeSet();
        TreeSet<Name> allNodeTypes = new TreeSet<Name>();
        HashMap namedItemDefs = new HashMap();
        ArrayList<Object> unnamedItemDefs = new ArrayList<Object>();
        HashSet<Name> supportedMixins = null;
        Name ntName = ntd.getName();
        mergedNodeTypes.add(ntName);
        allNodeTypes.add(ntName);
        Name[] smixins = ntd.getSupportedMixinTypes();
        if (smixins != null) {
            supportedMixins = new HashSet<Name>();
            int i = 0;
            while (i < smixins.length) {
                supportedMixins.add(smixins[i]);
                ++i;
            }
        }
        HashSet<Object> itemDefIds = new HashSet<Object>();
        QNodeDefinition[] cnda = ntd.getChildNodeDefs();
        int i = 0;
        while (i < cnda.length) {
            if (itemDefIds.contains(cnda[i])) {
                String msg = cnda[i].definesResidual() ? ntName + " contains ambiguous residual child node definitions" : ntName + " contains ambiguous definitions for child node named " + cnda[i].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(cnda[i]);
            if (cnda[i].definesResidual()) {
                unnamedItemDefs.add(cnda[i]);
            } else {
                Name name = cnda[i].getName();
                ArrayList<QNodeDefinition> defs = (ArrayList<QNodeDefinition>)namedItemDefs.get(name);
                if (defs == null) {
                    defs = new ArrayList<QNodeDefinition>();
                    namedItemDefs.put(name, defs);
                }
                if (defs.size() > 0) {
                    int j = 0;
                    while (j < defs.size()) {
                        QItemDefinition qDef = (QItemDefinition)defs.get(j);
                        if (cnda[i].isAutoCreated() || qDef.isAutoCreated()) {
                            String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                            log.debug(msg);
                            throw new ConstraintViolationException(msg);
                        }
                        ++j;
                    }
                }
                defs.add(cnda[i]);
            }
            ++i;
        }
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        int i2 = 0;
        while (i2 < pda.length) {
            if (itemDefIds.contains(pda[i2])) {
                String msg = pda[i2].definesResidual() ? ntName + " contains ambiguous residual property definitions" : ntName + " contains ambiguous definitions for property named " + pda[i2].getName();
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            itemDefIds.add(pda[i2]);
            if (pda[i2].definesResidual()) {
                unnamedItemDefs.add(pda[i2]);
            } else {
                Name name = pda[i2].getName();
                ArrayList<QPropertyDefinition> defs = (ArrayList<QPropertyDefinition>)namedItemDefs.get(name);
                if (defs == null) {
                    defs = new ArrayList<QPropertyDefinition>();
                    namedItemDefs.put(name, defs);
                }
                if (defs.size() > 0) {
                    int j = 0;
                    while (j < defs.size()) {
                        QItemDefinition qDef = (QItemDefinition)defs.get(j);
                        if (pda[i2].isAutoCreated() || qDef.isAutoCreated()) {
                            String msg = "There are more than one 'auto-create' item definitions for '" + name + "' in node type '" + ntName + "'";
                            log.debug(msg);
                            throw new ConstraintViolationException(msg);
                        }
                        ++j;
                    }
                }
                defs.add(pda[i2]);
            }
            ++i2;
        }
        EffectiveNodeTypeImpl ent = new EffectiveNodeTypeImpl(mergedNodeTypes, inheritedNodeTypes, allNodeTypes, namedItemDefs, unnamedItemDefs, supportedMixins);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            EffectiveNodeTypeImpl effSuperType = (EffectiveNodeTypeImpl)this.getEffectiveNodeType(supertypes, ntdMap);
            ent.internalMerge(effSuperType, true);
        }
        return ent;
    }

    private EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        QNodeTypeDefinition ntd = (QNodeTypeDefinition)ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = this.getEffectiveNodeType(ntd, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (ConstraintViolationException e) {
                String msg = "Internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map ntdCache) throws ConstraintViolationException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        int i = 0;
        while (i < ntNames.length) {
            if (!ntdCache.containsKey(ntNames[i])) {
                throw new NoSuchNodeTypeException(ntNames[i].toString());
            }
            ++i;
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeTypeImpl result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeTypeImpl ent = (EffectiveNodeTypeImpl)entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                Name[] remainder = key.getNames();
                int i2 = 0;
                while (i2 < remainder.length) {
                    QNodeTypeDefinition ntd = (QNodeTypeDefinition)ntdCache.get(remainder[i2]);
                    EffectiveNodeType ent = this.getEffectiveNodeType(ntd, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = (EffectiveNodeTypeImpl)ent;
                    } else {
                        result = result.merge((EffectiveNodeTypeImpl)ent);
                        entCache.put(result);
                    }
                    ++i2;
                }
                break block4;
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        int i = 0;
        while (i < la.length) {
            if (la[i] != null) {
                la[i].nodeTypeRegistered(ntName);
            }
            ++i;
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        int i = 0;
        while (i < la.length) {
            if (la[i] != null) {
                la[i].nodeTypeReRegistered(ntName);
            }
            ++i;
        }
    }

    private void notifyUnregistered(Name ntName) {
        NodeTypeRegistryListener[] la = new NodeTypeRegistryListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (NodeTypeRegistryListener)iter.next();
        }
        int i = 0;
        while (i < la.length) {
            if (la[i] != null) {
                la[i].nodeTypeUnregistered(ntName);
            }
            ++i;
        }
    }

    private void internalRegister(Map defMap) {
        Iterator it = defMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            QNodeTypeDefinition ntd = (QNodeTypeDefinition)entry.getKey();
            this.internalRegister(ntd, (EffectiveNodeTypeImpl)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRegister(QNodeTypeDefinition ntd, EffectiveNodeType ent) {
        if (ent != null) {
            this.entCache.put(ent);
        } else {
            log.debug("Effective node type for " + ntd + " not yet built.");
        }
        this.registeredNTDefs.put(ntd.getName(), ntd);
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        Set set = this.propDefs;
        synchronized (set) {
            int i = 0;
            while (i < pda.length) {
                this.propDefs.add(pda[i]);
                ++i;
            }
        }
        QNodeDefinition[] nda = ntd.getChildNodeDefs();
        Set set2 = this.nodeDefs;
        synchronized (set2) {
            int i = 0;
            while (i < nda.length) {
                this.nodeDefs.add(nda[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregister(Name name) {
        QNodeTypeDefinition ntd = (QNodeTypeDefinition)this.registeredNTDefs.remove(name);
        this.entCache.invalidate(name);
        if (ntd != null) {
            QPropertyDefinition[] pda = ntd.getPropertyDefs();
            Set set = this.propDefs;
            synchronized (set) {
                int i = 0;
                while (i < pda.length) {
                    this.propDefs.remove(pda[i]);
                    ++i;
                }
            }
            set = this.nodeDefs;
            synchronized (set) {
                QNodeDefinition[] nda = ntd.getChildNodeDefs();
                int i = 0;
                while (i < nda.length) {
                    this.nodeDefs.remove(nda[i]);
                    ++i;
                }
            }
        }
    }

    private void internalUnregister(Collection ntNames) {
        Iterator iter = ntNames.iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            this.internalUnregister(name);
        }
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Known NodeTypes:");
        ps.println();
        this.registeredNTDefs.dump(ps);
        ps.println();
        this.entCache.dump(ps);
    }

    private class NodeTypeDefinitionMap
    implements Map,
    Dumpable {
        private final ConcurrentReaderHashMap nodetypeDefinitions = new ConcurrentReaderHashMap();

        private NodeTypeDefinitionMap() {
        }

        private Set getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
            if (!this.nodetypeDefinitions.containsKey((Object)nodeTypeName)) {
                throw new NoSuchNodeTypeException(nodeTypeName.toString());
            }
            HashSet<Name> names = new HashSet<Name>();
            Iterator iter = this.nodetypeDefinitions.values().iterator();
            while (iter.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iter.next();
                if (!ntd.getDependencies().contains(nodeTypeName)) continue;
                names.add(ntd.getName());
            }
            return names;
        }

        private void updateInternalMap(Iterator definitions) {
            while (definitions.hasNext()) {
                NodeTypeRegistryImpl.this.internalRegister((QNodeTypeDefinition)definitions.next(), null);
            }
        }

        public int size() {
            return this.nodetypeDefinitions.size();
        }

        public void clear() {
            this.nodetypeDefinitions.clear();
        }

        public boolean isEmpty() {
            return this.nodetypeDefinitions.isEmpty();
        }

        public boolean containsKey(Object key) {
            if (!(key instanceof Name)) {
                return false;
            }
            return this.get(key) != null;
        }

        public boolean containsValue(Object value) {
            if (!(value instanceof QNodeTypeDefinition)) {
                return false;
            }
            return this.get(((QNodeTypeDefinition)value).getName()) != null;
        }

        public Set keySet() {
            try {
                Iterator it = NodeTypeRegistryImpl.this.storage.getAllDefinitions();
                this.updateInternalMap(it);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            return this.nodetypeDefinitions.keySet();
        }

        public Collection values() {
            this.keySet();
            return this.nodetypeDefinitions.values();
        }

        public Object put(Object key, Object value) {
            return this.nodetypeDefinitions.put(key, value);
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException("Implementation missing");
        }

        public Set entrySet() {
            this.keySet();
            return this.nodetypeDefinitions.entrySet();
        }

        public Object get(Object key) {
            if (!(key instanceof Name)) {
                throw new IllegalArgumentException();
            }
            QNodeTypeDefinition def = (QNodeTypeDefinition)this.nodetypeDefinitions.get(key);
            if (def == null) {
                try {
                    Iterator it = NodeTypeRegistryImpl.this.storage.getDefinitions(new Name[]{(Name)key});
                    this.updateInternalMap(it);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            def = (QNodeTypeDefinition)this.nodetypeDefinitions.get(key);
            return def;
        }

        public Object remove(Object key) {
            return (QNodeTypeDefinition)this.nodetypeDefinitions.remove(key);
        }

        public void dump(PrintStream ps) {
            Iterator iter = this.nodetypeDefinitions.values().iterator();
            while (iter.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iter.next();
                ps.println(ntd.getName());
                Name[] supertypes = ntd.getSupertypes();
                ps.println("\tSupertypes");
                int i = 0;
                while (i < supertypes.length) {
                    ps.println("\t\t" + supertypes[i]);
                    ++i;
                }
                ps.println("\tMixin\t" + ntd.isMixin());
                ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
                ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
                QPropertyDefinition[] pd = ntd.getPropertyDefs();
                int i2 = 0;
                while (i2 < pd.length) {
                    ps.print("\tPropertyDefinition");
                    ps.println(" (declared in " + pd[i2].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (pd[i2].definesResidual() ? "*" : pd[i2].getName().toString()));
                    String type = pd[i2].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)pd[i2].getRequiredType());
                    ps.println("\t\tRequiredType\t" + type);
                    String[] vca = pd[i2].getValueConstraints();
                    StringBuffer constraints = new StringBuffer();
                    if (vca == null) {
                        constraints.append("<null>");
                    } else {
                        int n = 0;
                        while (n < vca.length) {
                            if (constraints.length() > 0) {
                                constraints.append(", ");
                            }
                            constraints.append(vca[n]);
                            ++n;
                        }
                    }
                    ps.println("\t\tValueConstraints\t" + constraints.toString());
                    QValue[] defVals = pd[i2].getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        int n = 0;
                        while (n < defVals.length) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            try {
                                defaultValues.append(defVals[n].getString());
                            }
                            catch (RepositoryException e) {
                                defaultValues.append(defVals[n].toString());
                            }
                            ++n;
                        }
                    }
                    ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                    ps.println("\t\tAutoCreated\t" + pd[i2].isAutoCreated());
                    ps.println("\t\tMandatory\t" + pd[i2].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)pd[i2].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + pd[i2].isProtected());
                    ps.println("\t\tMultiple\t" + pd[i2].isMultiple());
                    ++i2;
                }
                QNodeDefinition[] nd = ntd.getChildNodeDefs();
                int i3 = 0;
                while (i3 < nd.length) {
                    Name defPrimaryType;
                    ps.print("\tNodeDefinition");
                    ps.println(" (declared in " + nd[i3].getDeclaringNodeType() + ") ");
                    ps.println("\t\tName\t\t" + (nd[i3].definesResidual() ? "*" : nd[i3].getName().toString()));
                    Name[] reqPrimaryTypes = nd[i3].getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        int n = 0;
                        while (n < reqPrimaryTypes.length) {
                            ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n]);
                            ++n;
                        }
                    }
                    if ((defPrimaryType = nd[i3].getDefaultPrimaryType()) != null) {
                        ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                    }
                    ps.println("\n\t\tAutoCreated\t" + nd[i3].isAutoCreated());
                    ps.println("\t\tMandatory\t" + nd[i3].isMandatory());
                    ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nd[i3].getOnParentVersion()));
                    ps.println("\t\tProtected\t" + nd[i3].isProtected());
                    ps.println("\t\tAllowsSameNameSiblings\t" + nd[i3].allowsSameNameSiblings());
                    ++i3;
                }
            }
        }
    }
}

