/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static Logger log;
    private final ValueFactory valueFactory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.nodetype.PropertyDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    PropertyDefinitionImpl(QPropertyDefinition propDef, NodeTypeManagerImpl ntMgr, NamePathResolver resolver, ValueFactory valueFactory) {
        super((QItemDefinition)propDef, ntMgr, resolver);
        this.valueFactory = valueFactory;
    }

    public Value[] getDefaultValues() {
        QPropertyDefinition pDef = (QPropertyDefinition)this.itemDef;
        QValue[] defVals = pDef.getDefaultValues();
        if (defVals == null) {
            return null;
        }
        Value[] values = new Value[defVals.length];
        int i = 0;
        while (i < defVals.length) {
            try {
                values[i] = ValueFormat.getJCRValue((QValue)defVals[i], (NamePathResolver)this.resolver, (ValueFactory)this.valueFactory);
            }
            catch (RepositoryException e) {
                String propName = this.getName() == null ? "[null]" : this.getName();
                log.error("illegal default value specified for property " + propName + " in node type " + this.getDeclaringNodeType(), (Throwable)e);
                return null;
            }
            ++i;
        }
        return values;
    }

    public int getRequiredType() {
        return ((QPropertyDefinition)this.itemDef).getRequiredType();
    }

    public String[] getValueConstraints() {
        QPropertyDefinition pd = (QPropertyDefinition)this.itemDef;
        String[] constraints = pd.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return new String[0];
        }
        try {
            String[] vca = new String[constraints.length];
            int i = 0;
            while (i < constraints.length) {
                ValueConstraint constr = ValueConstraint.create((int)pd.getRequiredType(), (String)constraints[i]);
                vca[i] = constr.getDefinition(this.resolver);
                ++i;
            }
            return vca;
        }
        catch (InvalidConstraintException e) {
            log.error("Invalid value constraint: " + e.getMessage());
            return null;
        }
    }

    public boolean isMultiple() {
        return ((QPropertyDefinition)this.itemDef).isMultiple();
    }
}

