/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.jcr2spi.observation.EventImpl;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilteredEventIterator
implements EventIterator {
    private static final Logger log;
    private final Iterator actualEvents;
    private final EventFilter filter;
    private final boolean isLocal;
    private final NamePathResolver resolver;
    private Event next;
    private long pos = 0L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.observation.FilteredEventIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public FilteredEventIterator(EventBundle events, EventFilter filter, NamePathResolver resolver) {
        this.actualEvents = events.getEvents();
        this.filter = filter;
        this.isLocal = events.isLocal();
        this.resolver = resolver;
        this.fetchNext();
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Event e = this.next;
        this.fetchNext();
        ++this.pos;
        return e;
    }

    public Event nextEvent() {
        return (Event)this.next();
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    public long getSize() {
        return -1L;
    }

    public long getPosition() {
        return this.pos;
    }

    public void remove() {
        throw new UnsupportedOperationException("EventIterator.remove()");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private void fetchNext() {
        this.next = null;
        while (this.next == null && this.actualEvents.hasNext()) {
            org.apache.jackrabbit.spi.Event event = (org.apache.jackrabbit.spi.Event)this.actualEvents.next();
            EventImpl eventImpl = this.next = this.filter.accept(event, this.isLocal) ? new EventImpl(this.resolver, event) : null;
        }
    }
}

