/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNode
extends AbstractOperation {
    private static Logger log;
    private final NodeId parentId;
    private final NodeState parentState;
    private final Name nodeName;
    private final Name nodeTypeName;
    private final String uuid;
    private List addedStates = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.operation.AddNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.operation.AddNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz2);
    }

    private AddNode(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        this.parentId = parentState.getNodeId();
        this.parentState = parentState;
        this.nodeName = nodeName;
        this.nodeTypeName = nodeTypeName;
        this.uuid = uuid;
        this.addAffectedItemState(parentState);
    }

    public void accept(OperationVisitor visitor) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        this.parentState.getHierarchyEntry().complete(this);
    }

    public void undo() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 2;
        this.parentState.getHierarchyEntry().complete(this);
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public NodeState getParentState() {
        return this.parentState;
    }

    public Name getNodeName() {
        return this.nodeName;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void addedState(List newStates) {
        this.addedStates.addAll(newStates);
    }

    public List getAddedStates() {
        return this.addedStates;
    }

    public static Operation create(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        AddNode.assertChildNodeEntries(parentState);
        AddNode an = new AddNode(parentState, nodeName, nodeTypeName, uuid);
        return an;
    }
}

