/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move
extends AbstractOperation {
    private static Logger log;
    private final NodeId srcId;
    private final NodeId destParentId;
    private final Name destName;
    private final NodeState srcState;
    private final NodeState srcParentState;
    private final NodeState destParentState;
    private final boolean sessionMove;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.operation.Move");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.operation.Move");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz2);
    }

    private Move(NodeState srcNodeState, NodeState srcParentState, NodeState destParentState, Name destName, boolean sessionMove) throws RepositoryException {
        this.srcId = (NodeId)srcNodeState.getId();
        this.destParentId = destParentState.getNodeId();
        this.destName = destName;
        this.srcState = srcNodeState;
        this.srcParentState = srcParentState;
        this.destParentState = destParentState;
        this.sessionMove = sessionMove;
        this.addAffectedItemState(srcNodeState);
        this.addAffectedItemState(srcParentState);
        this.addAffectedItemState(destParentState);
    }

    public void accept(OperationVisitor visitor) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        if (this.sessionMove) {
            this.srcState.getNodeEntry().complete(this);
        } else {
            try {
                this.srcState.getNodeEntry().move(this.destName, this.destParentState.getNodeEntry(), false);
            }
            catch (RepositoryException e) {
                log.error("Internal error", (Throwable)e);
                this.srcParentState.getHierarchyEntry().invalidate(false);
                this.destParentState.getHierarchyEntry().invalidate(false);
                this.srcState.getHierarchyEntry().invalidate(false);
            }
        }
    }

    public void undo() throws RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        if (this.sessionMove) {
            this.status = 2;
            this.srcState.getHierarchyEntry().complete(this);
        } else {
            super.undo();
        }
    }

    public NodeId getSourceId() {
        return this.srcId;
    }

    public NodeId getDestinationParentId() {
        return this.destParentId;
    }

    public NodeState getSourceState() {
        return this.srcState;
    }

    public NodeState getSourceParentState() {
        return this.srcParentState;
    }

    public NodeState getDestinationParentState() {
        return this.destParentState;
    }

    public Name getDestinationName() {
        return this.destName;
    }

    public static Operation create(Path srcPath, Path destPath, HierarchyManager hierMgr, PathResolver resolver, boolean sessionMove) throws ItemExistsException, NoSuchNodeTypeException, RepositoryException {
        if (srcPath.isAncestorOf(destPath)) {
            String msg = "Invalid destination path: cannot be descendant of source path (" + LogUtil.safeGetJCRPath(destPath, resolver) + "," + LogUtil.safeGetJCRPath(srcPath, resolver) + ")";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        Path.Element destElement = destPath.getNameElement();
        int index = destElement.getIndex();
        if (index > 0) {
            String msg = "Invalid destination path: subscript in name element is not allowed (" + LogUtil.safeGetJCRPath(destPath, resolver) + ")";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (srcPath.denotesRoot() || destPath.denotesRoot()) {
            String msg = "Cannot move the root node.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeState srcState = Move.getNodeState(srcPath, hierMgr);
        NodeState srcParentState = Move.getNodeState(srcPath.getAncestor(1), hierMgr);
        NodeState destParentState = Move.getNodeState(destPath.getAncestor(1), hierMgr);
        Name destName = destElement.getName();
        if (sessionMove) {
            NodeEntry existing;
            NodeEntry destEntry = (NodeEntry)destParentState.getHierarchyEntry();
            if (destEntry.hasPropertyEntry(destName)) {
                throw new ItemExistsException("Move destination already exists (Property).");
            }
            Move.assertChildNodeEntries(srcParentState);
            Move.assertChildNodeEntries(destParentState);
            if (destEntry.hasNodeEntry(destName) && (existing = destEntry.getNodeEntry(destName, 1)) != null && sessionMove) {
                try {
                    if (!existing.getNodeState().getDefinition().allowsSameNameSiblings()) {
                        throw new ItemExistsException("Node existing at move destination does not allow same name siblings.");
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        Move move = new Move(srcState, srcParentState, destParentState, destName, sessionMove);
        return move;
    }
}

