/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;

public class Restore
extends AbstractOperation {
    private final NodeState nodeState;
    private final Path relQPath;
    private final NodeState[] versionStates;
    private final boolean removeExisting;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.operation.Restore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private Restore(NodeState nodeState, Path relQPath, NodeState[] versionStates, boolean removeExisting) {
        this.nodeState = nodeState;
        this.relQPath = relQPath;
        this.versionStates = versionStates;
        this.removeExisting = removeExisting;
    }

    public void accept(OperationVisitor visitor) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        visitor.visit(this);
    }

    public void persisted() {
        NodeEntry entry;
        if (!$assertionsDisabled && this.status != 0) {
            throw new AssertionError();
        }
        this.status = 1;
        if (this.nodeState == null || this.removeExisting) {
            entry = this.nodeState == null ? this.versionStates[0].getNodeEntry() : this.nodeState.getNodeEntry();
            while (entry.getParent() != null) {
                entry = entry.getParent();
            }
        } else {
            entry = this.nodeState.getNodeEntry();
        }
        entry.invalidate(true);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState == null ? null : this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public Path getRelativePath() {
        return this.relQPath;
    }

    public NodeId[] getVersionIds() throws RepositoryException {
        NodeId[] versionIds = new NodeId[this.versionStates.length];
        int i = 0;
        while (i < this.versionStates.length) {
            versionIds[i] = this.versionStates[i].getNodeEntry().getWorkspaceId();
            ++i;
        }
        return versionIds;
    }

    public boolean removeExisting() {
        return this.removeExisting;
    }

    public static Operation create(NodeState nodeState, Path relQPath, NodeState versionState, boolean removeExisting) {
        if (nodeState == null || versionState == null) {
            throw new IllegalArgumentException("Neither nodeState nor versionState must be null.");
        }
        Restore up = new Restore(nodeState, relQPath, new NodeState[]{versionState}, removeExisting);
        return up;
    }

    public static Operation create(NodeState[] versionStates, boolean removeExisting) {
        if (versionStates == null || versionStates.length == 0) {
            throw new IllegalArgumentException("Version states must not be null.");
        }
        Restore up = new Restore(null, null, versionStates, removeExisting);
        return up;
    }
}

