/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.query.NodeIteratorImpl;
import org.apache.jackrabbit.jcr2spi.query.RowIteratorImpl;
import org.apache.jackrabbit.jcr2spi.query.ScoreNodeIterator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

class QueryResultImpl
implements QueryResult {
    private final ItemManager itemMgr;
    private final ManagerProvider mgrProvider;
    private final QueryInfo queryInfo;

    QueryResultImpl(ItemManager itemMgr, ManagerProvider mgrProvider, QueryInfo queryInfo) {
        this.itemMgr = itemMgr;
        this.mgrProvider = mgrProvider;
        this.queryInfo = queryInfo;
    }

    public String[] getColumnNames() throws RepositoryException {
        Name[] names = this.queryInfo.getColumnNames();
        String[] propNames = new String[names.length];
        NamePathResolver resolver = this.mgrProvider.getNamePathResolver();
        int i = 0;
        while (i < names.length) {
            propNames[i] = resolver.getJCRName(names[i]);
            ++i;
        }
        return propNames;
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.queryInfo, this.mgrProvider.getNamePathResolver(), this.mgrProvider.getJcrValueFactory());
    }

    private ScoreNodeIterator getNodeIterator() {
        return new NodeIteratorImpl(this.itemMgr, this.mgrProvider.getHierarchyManager(), this.queryInfo);
    }
}

