/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemStateFactory
implements ItemStateFactory {
    private static Logger log;
    private final Set creationListeners = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.state.AbstractItemStateFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreationListener(ItemStateCreationListener listener) {
        Set set = this.creationListeners;
        synchronized (set) {
            this.creationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCreationListener(ItemStateCreationListener listener) {
        Set set = this.creationListeners;
        synchronized (set) {
            this.creationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemStateCreationListener[] getListeners() {
        Set set = this.creationListeners;
        synchronized (set) {
            return this.creationListeners.toArray(new ItemStateCreationListener[this.creationListeners.size()]);
        }
    }

    void notifyCreated(ItemState createdState) {
        ItemStateCreationListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            createdState.addListener(listeners[i]);
            listeners[i].created(createdState);
            ++i;
        }
    }

    void notifyUpdated(ItemState state, int previousStatus) {
        ItemStateCreationListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].statusChanged(state, previousStatus);
            ++i;
        }
    }
}

