/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.version.VersionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public VersionImpl(SessionImpl session, NodeState state, ItemLifeCycleListener[] listeners) {
        super(session, state, listeners);
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return (VersionHistory)this.getParent();
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getProperty(NameConstants.JCR_CREATED).getDate();
    }

    public Version[] getSuccessors() throws RepositoryException {
        return this.getVersions(NameConstants.JCR_SUCCESSORS);
    }

    public Version[] getPredecessors() throws RepositoryException {
        return this.getVersions(NameConstants.JCR_PREDECESSORS);
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.checkStatus();
        if (otherItem instanceof VersionImpl) {
            VersionImpl other = (VersionImpl)otherItem;
            try {
                return this.getUUID().equals(other.getUUID());
            }
            catch (RepositoryException e) {
                log.error("Internal error while retrieving UUID of version.", (Throwable)e);
            }
        }
        return false;
    }

    protected void checkIsWritable() throws UnsupportedRepositoryOperationException, ConstraintViolationException, RepositoryException {
        super.checkIsWritable();
        throw new ConstraintViolationException("Version is protected");
    }

    protected boolean isWritable() throws RepositoryException {
        super.isWritable();
        return false;
    }

    private Version[] getVersions(Name propertyName) throws RepositoryException {
        Version[] versions;
        Value[] values = this.getProperty(propertyName).getValues();
        if (values != null) {
            versions = new Version[values.length];
            int i = 0;
            while (i < values.length) {
                Node n = this.session.getNodeByUUID(values[i].getString());
                if (!(n instanceof Version)) {
                    throw new RepositoryException("Version property contains invalid value not pointing to a 'Version'");
                }
                versions[i] = (Version)n;
                ++i;
            }
        } else {
            versions = new Version[]{};
        }
        return versions;
    }
}

