/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Iterator;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AddLabel;
import org.apache.jackrabbit.jcr2spi.operation.Checkin;
import org.apache.jackrabbit.jcr2spi.operation.Checkout;
import org.apache.jackrabbit.jcr2spi.operation.Merge;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.RemoveLabel;
import org.apache.jackrabbit.jcr2spi.operation.RemoveVersion;
import org.apache.jackrabbit.jcr2spi.operation.ResolveMergeConflict;
import org.apache.jackrabbit.jcr2spi.operation.Restore;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionManagerImpl
implements VersionManager {
    private static Logger log;
    private final WorkspaceManager workspaceManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.version.VersionManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public VersionManagerImpl(WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public NodeEntry checkin(NodeState nodeState) throws RepositoryException {
        Checkin ci = Checkin.create(nodeState, this);
        this.workspaceManager.execute(ci);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(ci.getNewVersionId());
    }

    public void checkout(NodeState nodeState) throws RepositoryException {
        Operation co = Checkout.create(nodeState, this);
        this.workspaceManager.execute(co);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCheckedOut(NodeState nodeState) throws RepositoryException {
        if (nodeState.getStatus() == 4) {
            return true;
        }
        NodeEntry nodeEntry = nodeState.getNodeEntry();
        try {
            while (true) {
                if (nodeEntry.hasPropertyEntry(NameConstants.JCR_ISCHECKEDOUT)) {
                    PropertyState propState = nodeEntry.getPropertyEntry(NameConstants.JCR_ISCHECKEDOUT).getPropertyState();
                    Boolean b = Boolean.valueOf(propState.getValue().getString());
                    return b;
                }
                NodeEntry parent = nodeEntry.getParent();
                if (parent == null) {
                    return true;
                }
                nodeEntry = parent;
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return true;
        }
    }

    public void checkIsCheckedOut(NodeState nodeState) throws VersionException, RepositoryException {
        if (!this.isCheckedOut(nodeState)) {
            throw new VersionException(nodeState + " is checked-in");
        }
    }

    public void removeVersion(NodeState versionHistoryState, NodeState versionState) throws RepositoryException {
        Operation op = RemoveVersion.create(versionState, versionHistoryState, this);
        this.workspaceManager.execute(op);
    }

    public void addVersionLabel(NodeState versionHistoryState, NodeState versionState, Name qLabel, boolean moveLabel) throws RepositoryException {
        Operation op = AddLabel.create(versionHistoryState, versionState, qLabel, moveLabel);
        this.workspaceManager.execute(op);
    }

    public void removeVersionLabel(NodeState versionHistoryState, NodeState versionState, Name qLabel) throws RepositoryException {
        Operation op = RemoveLabel.create(versionHistoryState, versionState, qLabel);
        this.workspaceManager.execute(op);
    }

    public void restore(NodeState nodeState, Path relativePath, NodeState versionState, boolean removeExisting) throws RepositoryException {
        Operation op = Restore.create(nodeState, relativePath, versionState, removeExisting);
        this.workspaceManager.execute(op);
    }

    public void restore(NodeState[] versionStates, boolean removeExisting) throws RepositoryException {
        Operation op = Restore.create(versionStates, removeExisting);
        this.workspaceManager.execute(op);
    }

    public Iterator merge(NodeState nodeState, String workspaceName, boolean bestEffort) throws RepositoryException {
        Merge op = Merge.create(nodeState, workspaceName, bestEffort, this);
        this.workspaceManager.execute(op);
        return op.getFailedIds();
    }

    public void resolveMergeConflict(NodeState nodeState, NodeState versionState, boolean done) throws RepositoryException {
        NodeId vId = versionState.getNodeId();
        PropertyState mergeFailedState = nodeState.getPropertyState(NameConstants.JCR_MERGEFAILED);
        QValue[] vs = mergeFailedState.getValues();
        NodeId[] mergeFailedIds = new NodeId[vs.length - 1];
        int i = 0;
        int j = 0;
        while (i < vs.length) {
            NodeId id = this.workspaceManager.getIdFactory().createNodeId(vs[i].getString());
            if (!id.equals(vId)) {
                mergeFailedIds[j] = id;
                ++j;
            }
            ++i;
        }
        PropertyState predecessorState = nodeState.getPropertyState(NameConstants.JCR_PREDECESSORS);
        vs = predecessorState.getValues();
        int noOfPredecessors = done ? vs.length + 1 : vs.length;
        NodeId[] predecessorIds = new NodeId[noOfPredecessors];
        int i2 = 0;
        while (i2 < vs.length) {
            predecessorIds[i2] = this.workspaceManager.getIdFactory().createNodeId(vs[i2].getString());
            ++i2;
        }
        if (done) {
            predecessorIds[i2] = vId;
        }
        Operation op = ResolveMergeConflict.create(nodeState, mergeFailedIds, predecessorIds, done);
        this.workspaceManager.execute(op);
    }

    public NodeEntry getVersionableNodeEntry(NodeState versionState) throws RepositoryException {
        NodeState ns = versionState.getChildNodeState(NameConstants.JCR_FROZENNODE, 1);
        PropertyState ps = ns.getPropertyState(NameConstants.JCR_FROZENUUID);
        String uniqueID = ps.getValue().getString();
        NodeId versionableId = this.workspaceManager.getIdFactory().createNodeId(uniqueID);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(versionableId);
    }

    public NodeEntry getVersionHistoryEntry(NodeState versionableState) throws RepositoryException {
        PropertyState ps = versionableState.getPropertyState(NameConstants.JCR_VERSIONHISTORY);
        String uniqueID = ps.getValue().getString();
        NodeId vhId = this.workspaceManager.getIdFactory().createNodeId(uniqueID);
        return this.workspaceManager.getHierarchyManager().getNodeEntry(vhId);
    }
}

