/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.xml.Importer;
import org.apache.jackrabbit.jcr2spi.xml.TargetImportHandler;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SysViewImportHandler
extends TargetImportHandler {
    private static final String NODE = "node";
    private static final String PROPERTY = "property";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private final Stack stack = new Stack();
    private Name currentPropName;
    private int currentPropType = 0;
    private ArrayList currentPropValues = new ArrayList();
    private TargetImportHandler.AppendableValue currentPropValue;

    SysViewImportHandler(Importer importer, NamePathResolver resolver) {
        super(importer, resolver);
    }

    private void processNode(ImportState state, boolean start, boolean end) throws SAXException {
        if (!start && !end) {
            return;
        }
        Name[] mixins = null;
        if (state.mixinNames != null) {
            mixins = state.mixinNames.toArray(new Name[state.mixinNames.size()]);
        }
        Importer.NodeInfo nodeInfo = new Importer.NodeInfo(state.nodeName, state.nodeTypeName, mixins, state.uuid);
        if (state.uuid != null) {
            nodeInfo.setUUID(state.uuid);
        }
        try {
            if (start) {
                this.importer.startNode(nodeInfo, state.props, this.resolver);
                Iterator iter = state.props.iterator();
                while (iter.hasNext()) {
                    Importer.PropInfo pi = (Importer.PropInfo)iter.next();
                    this.disposePropertyValues(pi);
                }
            }
            if (end) {
                this.importer.endNode(nodeInfo);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI)) {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid namespace for element in system view xml document: " + namespaceURI));
        }
        if (NODE.equals(localName)) {
            String name = atts.getValue("http://www.jcp.org/jcr/sv/1.0", NAME);
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:node"));
            }
            if (!this.stack.isEmpty()) {
                ImportState current = (ImportState)this.stack.peek();
                if (!current.started) {
                    this.processNode(current, true, false);
                    current.started = true;
                }
            }
            ImportState state = new ImportState();
            try {
                state.nodeName = this.resolver.getQName(name);
            }
            catch (NameException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)e));
            }
            catch (NamespaceException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)e));
            }
            this.stack.push(state);
        } else if (PROPERTY.equals(localName)) {
            this.currentPropValues.clear();
            String name = atts.getValue("http://www.jcp.org/jcr/sv/1.0", NAME);
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:property"));
            }
            try {
                this.currentPropName = this.resolver.getQName(name);
            }
            catch (NameException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)e));
            }
            catch (NamespaceException e) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)e));
            }
            String type = atts.getValue("http://www.jcp.org/jcr/sv/1.0", TYPE);
            if (type == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:type attribute of element sv:property"));
            }
            this.currentPropType = PropertyType.valueFromName((String)type);
        } else if (VALUE.equals(localName)) {
            this.currentPropValue = new TargetImportHandler.BufferedStringValue(this);
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("unexpected element found in system view xml document: " + localName));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ImportState state = (ImportState)this.stack.peek();
        if (NODE.equals(localName)) {
            if (!state.started) {
                this.processNode(state, true, true);
                state.started = true;
            } else {
                this.processNode(state, false, true);
            }
            this.stack.pop();
        } else if (PROPERTY.equals(localName)) {
            if (this.currentPropName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(0);
                String s = null;
                try {
                    s = val.retrieve();
                    state.nodeTypeName = this.resolver.getQName(s);
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
                catch (NameException e) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)e));
                }
                catch (NamespaceException e) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)e));
                }
            }
            if (this.currentPropName.equals(NameConstants.JCR_MIXINTYPES)) {
                if (state.mixinNames == null) {
                    state.mixinNames = new ArrayList(this.currentPropValues.size());
                }
                int i = 0;
                while (i < this.currentPropValues.size()) {
                    TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(i);
                    String s = null;
                    try {
                        s = val.retrieve();
                        Name mixin = this.resolver.getQName(s);
                        state.mixinNames.add(mixin);
                    }
                    catch (IOException ioe) {
                        throw new SAXException("error while retrieving value", ioe);
                    }
                    catch (NameException e) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)e));
                    }
                    catch (NamespaceException e) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)e));
                    }
                    ++i;
                }
            } else if (this.currentPropName.equals(NameConstants.JCR_UUID)) {
                TargetImportHandler.AppendableValue val = (TargetImportHandler.AppendableValue)this.currentPropValues.get(0);
                try {
                    state.uuid = val.retrieve();
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
            } else {
                Importer.TextValue[] values = this.currentPropValues.toArray(new Importer.TextValue[this.currentPropValues.size()]);
                Importer.PropInfo prop = new Importer.PropInfo(this.currentPropName, this.currentPropType, values);
                state.props.add(prop);
            }
            this.currentPropValues.clear();
        } else if (VALUE.equals(localName)) {
            this.currentPropValues.add(this.currentPropValue);
            this.currentPropValue = null;
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid element in system view xml document: " + localName));
        }
    }

    class ImportState {
        Name nodeName;
        Name nodeTypeName;
        ArrayList mixinNames;
        String uuid;
        ArrayList props = new ArrayList();
        boolean started = false;

        ImportState() {
        }
    }
}

