/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WorkspaceContentHandler
extends DefaultHandler {
    private static Logger log;
    private final String parentAbsPath;
    private final int uuidBehavior;
    private final Workspace workspace;
    private final File tmpFile;
    private final ContentHandler delegatee;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.jcr2spi.xml.WorkspaceContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public WorkspaceContentHandler(Workspace workspace, String parentAbsPath, int uuidBehavior) throws RepositoryException {
        this.workspace = workspace;
        this.parentAbsPath = parentAbsPath;
        this.uuidBehavior = uuidBehavior;
        try {
            String tmpName = Text.md5((String)parentAbsPath);
            this.tmpFile = File.createTempFile("___" + tmpName, ".xml");
            this.delegatee = SerializingContentHandler.getSerializer((OutputStream)new FileOutputStream(this.tmpFile));
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void endDocument() throws SAXException {
        this.delegatee.endDocument();
        try {
            try {
                this.workspace.importXML(this.parentAbsPath, (InputStream)new FileInputStream(this.tmpFile), this.uuidBehavior);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        finally {
            this.tmpFile.delete();
        }
    }

    public void startDocument() throws SAXException {
        this.delegatee.startDocument();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegatee.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.delegatee.ignorableWhitespace(ch, start, length);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.delegatee.endPrefixMapping(prefix);
    }

    public void skippedEntity(String name) throws SAXException {
        this.delegatee.skippedEntity(name);
    }

    public void setDocumentLocator(Locator locator) {
        this.delegatee.setDocumentLocator(locator);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.delegatee.processingInstruction(target, data);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.delegatee.startPrefixMapping(prefix, uri);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.delegatee.endElement(namespaceURI, localName, qName);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.delegatee.startElement(namespaceURI, localName, qName, atts);
    }
}

