/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateConfiguration
extends AbstractOperation {
    private static Logger log = LoggerFactory.getLogger(CreateConfiguration.class);
    private final NodeState nodeState;
    private final VersionManager mgr;
    private NodeId newConfigurationId;

    private CreateConfiguration(NodeState nodeState, VersionManager mgr) {
        this.nodeState = nodeState;
        this.mgr = mgr;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        this.nodeState.getHierarchyEntry().invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public void setNewConfigurationId(NodeId newConfigurationId) {
        this.newConfigurationId = newConfigurationId;
    }

    public NodeId getNewConfigurationId() {
        return this.newConfigurationId;
    }

    public static CreateConfiguration create(NodeState nodeState, VersionManager mgr) {
        return new CreateConfiguration(nodeState, mgr);
    }
}

