/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface VersionManager {
    public NodeEntry checkin(NodeState var1) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException;

    public void checkout(NodeState var1) throws UnsupportedRepositoryOperationException, LockException, RepositoryException;

    public void checkout(NodeState var1, NodeId var2) throws RepositoryException;

    public NodeEntry checkpoint(NodeState var1) throws RepositoryException;

    public NodeEntry checkpoint(NodeState var1, NodeId var2) throws RepositoryException;

    public boolean isCheckedOut(NodeState var1) throws RepositoryException;

    public void checkIsCheckedOut(NodeState var1) throws VersionException, RepositoryException;

    public void removeVersion(NodeState var1, NodeState var2) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException;

    public void addVersionLabel(NodeState var1, NodeState var2, Name var3, boolean var4) throws VersionException, RepositoryException;

    public void removeVersionLabel(NodeState var1, NodeState var2, Name var3) throws VersionException, RepositoryException;

    public void restore(NodeState var1, Path var2, NodeState var3, boolean var4) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException;

    public void restore(NodeState[] var1, boolean var2) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException;

    public Iterator<NodeId> merge(NodeState var1, String var2, boolean var3) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException;

    public Iterator<NodeId> merge(NodeState var1, String var2, boolean var3, boolean var4) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException;

    public void resolveMergeConflict(NodeState var1, NodeState var2, boolean var3) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException;

    public NodeEntry createConfiguration(NodeState var1) throws UnsupportedRepositoryOperationException, RepositoryException;

    public NodeEntry createActivity(String var1) throws UnsupportedRepositoryOperationException, RepositoryException;

    public void removeActivity(NodeState var1) throws UnsupportedRepositoryOperationException, RepositoryException;

    public Iterator<NodeId> mergeActivity(NodeState var1) throws UnsupportedRepositoryOperationException, RepositoryException;

    public NodeEntry getVersionableNodeEntry(NodeState var1) throws RepositoryException;

    public NodeEntry getVersionHistoryEntry(NodeState var1) throws RepositoryException;
}

