/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.jcr2spi.ItemCache;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCacheImpl
implements ItemCache {
    private static Logger log = LoggerFactory.getLogger(ItemCacheImpl.class);
    private final Map<ItemState, Item> cache;

    ItemCacheImpl(int maxSize) {
        this.cache = new LRUMap(maxSize);
    }

    public Item getItem(ItemState state) {
        return this.cache.get(state);
    }

    public void clear() {
        this.cache.clear();
    }

    public void itemCreated(Item item) {
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("created item " + item);
        }
        this.cacheItem(((ItemImpl)item).getItemState(), item);
    }

    public void itemUpdated(Item item, boolean modified) {
        ItemState state;
        Item cacheEntry;
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("update item " + item);
        }
        if ((cacheEntry = this.getItem(state = ((ItemImpl)item).getItemState())) == null) {
            this.cacheItem(state, item);
        }
    }

    public void itemDestroyed(Item item) {
        if (!(item instanceof ItemImpl)) {
            String msg = "Incompatible Item object: " + ItemImpl.class.getName() + " expected.";
            throw new IllegalArgumentException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug("destroyed item " + item);
        }
        ((ItemImpl)item).removeLifeCycleListener(this);
        this.evictItem(((ItemImpl)item).getItemState());
    }

    private synchronized void cacheItem(ItemState state, Item item) {
        if (this.cache.containsKey(state)) {
            log.warn("overwriting cached item " + state);
        }
        if (log.isDebugEnabled()) {
            log.debug("caching item " + state);
        }
        this.cache.put(state, item);
    }

    private synchronized void evictItem(ItemState itemState) {
        if (log.isDebugEnabled()) {
            log.debug("removing item " + itemState + " from cache");
        }
        this.cache.remove(itemState);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ItemState, Item> entry : this.cache.entrySet()) {
            String path;
            ItemState state = entry.getKey();
            Item item = entry.getValue();
            if (item.isNode()) {
                builder.append("Node: ");
            } else {
                builder.append("Property: ");
            }
            if (item.isNew()) {
                builder.append("new ");
            } else if (item.isModified()) {
                builder.append("modified ");
            } else {
                builder.append("- ");
            }
            try {
                path = item.getPath();
            }
            catch (RepositoryException e) {
                path = "-";
            }
            builder.append(state + "\t" + path + " (" + item + ")\n");
        }
        return builder.toString();
    }
}

