/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.NamespaceRegistryImpl;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEventListener;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManagerImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProviderImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeCache;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryImpl;
import org.apache.jackrabbit.jcr2spi.observation.InternalEventListener;
import org.apache.jackrabbit.jcr2spi.operation.AddLabel;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Checkin;
import org.apache.jackrabbit.jcr2spi.operation.Checkout;
import org.apache.jackrabbit.jcr2spi.operation.Checkpoint;
import org.apache.jackrabbit.jcr2spi.operation.Clone;
import org.apache.jackrabbit.jcr2spi.operation.Copy;
import org.apache.jackrabbit.jcr2spi.operation.CreateActivity;
import org.apache.jackrabbit.jcr2spi.operation.CreateConfiguration;
import org.apache.jackrabbit.jcr2spi.operation.LockOperation;
import org.apache.jackrabbit.jcr2spi.operation.LockRefresh;
import org.apache.jackrabbit.jcr2spi.operation.LockRelease;
import org.apache.jackrabbit.jcr2spi.operation.Merge;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.RemoveActivity;
import org.apache.jackrabbit.jcr2spi.operation.RemoveLabel;
import org.apache.jackrabbit.jcr2spi.operation.RemoveVersion;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.ResolveMergeConflict;
import org.apache.jackrabbit.jcr2spi.operation.Restore;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPrimaryType;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.operation.Update;
import org.apache.jackrabbit.jcr2spi.operation.WorkspaceImport;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.state.ChangeLog;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.TransientISFactory;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.state.WorkspaceItemStateFactory;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceManager
implements UpdatableItemStateManager,
NamespaceStorage,
AccessManager {
    private static Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    private final RepositoryService service;
    private final SessionInfo sessionInfo;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ItemStateFactory isf;
    private final HierarchyManager hierarchyManager;
    private final CacheBehaviour cacheBehaviour;
    private final boolean observationSupported;
    private final int pollTimeout;
    private final IdFactory idFactory;
    private final NamespaceRegistryImpl nsRegistry;
    private final NodeTypeRegistryImpl ntRegistry;
    private final ItemDefinitionProvider definitionProvider;
    private final Semaphore updateSync = new Semaphore(1);
    private Thread changeFeed;
    private volatile boolean disposeChangeFeed = false;
    private final List<InternalEventListener> listeners = new LinkedList<InternalEventListener>();
    private Subscription subscription;
    private ItemInfoCache cache;

    public WorkspaceManager(RepositoryService service, SessionInfo sessionInfo, CacheBehaviour cacheBehaviour, int pollTimeout, boolean observationSupported) throws RepositoryException {
        this.service = service;
        this.sessionInfo = sessionInfo;
        this.cacheBehaviour = cacheBehaviour;
        this.observationSupported = observationSupported;
        this.pollTimeout = pollTimeout;
        this.nameFactory = service.getNameFactory();
        this.pathFactory = service.getPathFactory();
        this.idFactory = service.getIdFactory();
        this.nsRegistry = new NamespaceRegistryImpl(this);
        this.ntRegistry = this.createNodeTypeRegistry(this.nsRegistry);
        this.definitionProvider = this.createDefinitionProvider(this.getEffectiveNodeTypeProvider());
        TransientItemStateFactory stateFactory = this.createItemStateFactory();
        this.isf = stateFactory;
        this.hierarchyManager = this.createHierarchyManager(stateFactory, this.idFactory);
        InternalEventListener listener = this.createHierarchyListener(this.hierarchyManager);
        if (cacheBehaviour == CacheBehaviour.OBSERVATION) {
            this.addEventListener(listener);
        } else {
            this.listeners.add(listener);
        }
    }

    public NamespaceRegistryImpl getNamespaceRegistryImpl() {
        return this.nsRegistry;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntRegistry;
    }

    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.definitionProvider;
    }

    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.ntRegistry;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierarchyManager;
    }

    public String[] getWorkspaceNames() throws RepositoryException {
        return this.service.getWorkspaceNames(this.sessionInfo);
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public ItemStateFactory getItemStateFactory() {
        return this.isf;
    }

    public LockInfo getLockInfo(NodeId nodeId) throws RepositoryException {
        return this.service.getLockInfo(this.sessionInfo, nodeId);
    }

    public String[] getLockTokens() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.sessionInfo.getLockTokens();
    }

    public void addLockToken(String lt) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.sessionInfo.addLockToken(lt);
    }

    public void removeLockToken(String lt) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        for (String token : this.sessionInfo.getLockTokens()) {
            if (!token.equals(lt)) continue;
            this.sessionInfo.removeLockToken(lt);
            return;
        }
        throw new LockException("Unable to remove locktoken '" + lt + "' from Session.");
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return this.service.getSupportedQueryLanguages(this.sessionInfo);
    }

    public String[] checkQueryStatement(String statement, String language, Map<String, String> namespaces) throws InvalidQueryException, RepositoryException {
        return this.service.checkQueryStatement(this.sessionInfo, statement, language, namespaces);
    }

    public QueryInfo executeQuery(String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> boundValues) throws RepositoryException {
        return this.service.executeQuery(this.sessionInfo, statement, language, namespaces, limit, offset, boundValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(InternalEventListener listener) throws RepositoryException {
        if (this.changeFeed == null) {
            this.changeFeed = this.createChangeFeed(this.pollTimeout, this.observationSupported);
        }
        List<InternalEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
            EventFilter[] filters = WorkspaceManager.getEventFilters(this.listeners);
            if (this.subscription == null) {
                this.subscription = this.service.createSubscription(this.sessionInfo, filters);
            } else {
                this.service.updateEventFilters(this.subscription, filters);
            }
            this.listeners.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventFilters() throws RepositoryException {
        List<InternalEventListener> list = this.listeners;
        synchronized (list) {
            this.service.updateEventFilters(this.subscription, WorkspaceManager.getEventFilters(this.listeners));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(InternalEventListener listener) throws RepositoryException {
        List<InternalEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.service.dispose(this.subscription);
                this.subscription = null;
            } else {
                this.service.updateEventFilters(this.subscription, WorkspaceManager.getEventFilters(this.listeners));
            }
        }
    }

    public EventFilter createEventFilter(int eventTypes, Path path, boolean isDeep, String[] uuids, Name[] nodeTypes, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.service.createEventFilter(this.sessionInfo, eventTypes, path, isDeep, uuids, nodeTypes, noLocal);
    }

    public EventBundle getEvents(EventFilter filter, long after) throws RepositoryException, UnsupportedRepositoryOperationException {
        return this.service.getEvents(this.sessionInfo, filter, after);
    }

    public void setUserData(String userData) throws RepositoryException {
        this.sessionInfo.setUserData(userData);
    }

    private static EventFilter[] getEventFilters(Collection<InternalEventListener> listeners) {
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>();
        for (InternalEventListener listener : listeners) {
            filters.addAll(listener.getEventFilters());
        }
        return filters.toArray(new EventFilter[filters.size()]);
    }

    private TransientItemStateFactory createItemStateFactory() throws RepositoryException {
        this.cache = this.service.getItemInfoCache(this.sessionInfo);
        WorkspaceItemStateFactory isf = new WorkspaceItemStateFactory(this.service, this.sessionInfo, this.getItemDefinitionProvider(), this.cache);
        TransientISFactory tisf = new TransientISFactory(isf, this.getItemDefinitionProvider());
        return tisf;
    }

    private HierarchyManager createHierarchyManager(TransientItemStateFactory tisf, IdFactory idFactory) throws RepositoryException {
        return new HierarchyManagerImpl(tisf, idFactory, this.getPathFactory());
    }

    private InternalEventListener createHierarchyListener(HierarchyManager hierarchyMgr) {
        HierarchyEventListener listener = new HierarchyEventListener(this, hierarchyMgr, this.cacheBehaviour);
        return listener;
    }

    private NodeTypeRegistryImpl createNodeTypeRegistry(NamespaceRegistry nsRegistry) {
        NodeTypeStorage ntst = new NodeTypeStorage(){

            public Iterator<QNodeTypeDefinition> getAllDefinitions() throws RepositoryException {
                return WorkspaceManager.this.service.getQNodeTypeDefinitions(WorkspaceManager.this.sessionInfo);
            }

            public Iterator<QNodeTypeDefinition> getDefinitions(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                return WorkspaceManager.this.service.getQNodeTypeDefinitions(WorkspaceManager.this.sessionInfo, nodeTypeNames);
            }

            public void registerNodeTypes(QNodeTypeDefinition[] nodeTypeDefs, boolean allowUpdate) throws RepositoryException {
                WorkspaceManager.this.service.registerNodeTypes(WorkspaceManager.this.sessionInfo, nodeTypeDefs, allowUpdate);
            }

            public void unregisterNodeTypes(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                WorkspaceManager.this.service.unregisterNodeTypes(WorkspaceManager.this.sessionInfo, nodeTypeNames);
            }
        };
        NodeTypeCache ntCache = NodeTypeCache.getInstance(this.service, this.sessionInfo.getUserID());
        ntst = ntCache.wrap(ntst);
        return NodeTypeRegistryImpl.create(ntst, nsRegistry);
    }

    private ItemDefinitionProvider createDefinitionProvider(EffectiveNodeTypeProvider entProvider) {
        return new ItemDefinitionProviderImpl(entProvider, this.service, this.sessionInfo);
    }

    private Thread createChangeFeed(int pollTimeout, boolean enableObservation) {
        Thread t = null;
        if (enableObservation) {
            t = new Thread(new ChangePolling(pollTimeout));
            t.setName("Change Polling");
            t.setDaemon(true);
            t.start();
        }
        return t;
    }

    void createWorkspace(String name, String srcWorkspaceName) throws RepositoryException {
        this.service.createWorkspace(this.sessionInfo, name, srcWorkspaceName);
    }

    void deleteWorkspace(String name) throws RepositoryException {
        this.service.deleteWorkspace(this.sessionInfo, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Operation operation) throws RepositoryException {
        try {
            this.updateSync.acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException((Throwable)e);
        }
        try {
            new OperationVisitorImpl(this.sessionInfo).execute(operation);
            operation.persisted();
        }
        finally {
            this.updateSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ChangeLog changes) throws RepositoryException {
        try {
            this.updateSync.acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException((Throwable)e);
        }
        try {
            new OperationVisitorImpl(this.sessionInfo).execute(changes);
            changes.persisted();
        }
        finally {
            this.updateSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        try {
            this.updateSync.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Exception while disposing WorkspaceManager: " + e);
            return;
        }
        try {
            if (this.changeFeed != null) {
                this.disposeChangeFeed = true;
                this.changeFeed.interrupt();
                this.changeFeed.join();
            }
            this.hierarchyManager.dispose();
            if (this.subscription != null) {
                this.service.dispose(this.subscription);
            }
            this.service.dispose(this.sessionInfo);
            this.cache.dispose();
        }
        catch (Exception e) {
            log.warn("Exception while disposing WorkspaceManager: " + e);
        }
        finally {
            this.updateSync.release();
        }
        this.ntRegistry.dispose();
    }

    @Override
    public boolean isGranted(NodeState parentState, Path relPath, String[] actions) throws ItemNotFoundException, RepositoryException {
        if (parentState.getStatus() == 4) {
            return true;
        }
        NodeId id = this.idFactory.createNodeId((NodeId)parentState.getWorkspaceId(), relPath);
        return this.service.isGranted(this.sessionInfo, (ItemId)id, actions);
    }

    @Override
    public boolean isGranted(ItemState itemState, String[] actions) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), actions);
    }

    @Override
    public boolean canRead(ItemState itemState) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), AccessManager.READ);
    }

    @Override
    public boolean canRemove(ItemState itemState) throws ItemNotFoundException, RepositoryException {
        if (itemState.getStatus() == 4) {
            return true;
        }
        return this.service.isGranted(this.sessionInfo, itemState.getWorkspaceId(), AccessManager.REMOVE);
    }

    @Override
    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        for (String wspName : this.getWorkspaceNames()) {
            if (!wspName.equals(workspaceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getRegisteredNamespaces() throws RepositoryException {
        return this.service.getRegisteredNamespaces(this.sessionInfo);
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        return this.service.getNamespacePrefix(this.sessionInfo, uri);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        return this.service.getNamespaceURI(this.sessionInfo, prefix);
    }

    @Override
    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.service.registerNamespace(this.sessionInfo, prefix, uri);
    }

    @Override
    public void unregisterNamespace(String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.service.unregisterNamespace(this.sessionInfo, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventReceived(EventBundle[] eventBundles, InternalEventListener[] lstnrs) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("received {} event bundles.", (Object)eventBundles.length);
            for (EventBundle eventBundle : eventBundles) {
                log.debug("IsLocal:  {}", (Object)eventBundle.isLocal());
                Iterator it = eventBundle.getEvents();
                while (it.hasNext()) {
                    String type;
                    Event e = (Event)it.next();
                    switch (e.getType()) {
                        case 1: {
                            type = "NodeAdded";
                            break;
                        }
                        case 2: {
                            type = "NodeRemoved";
                            break;
                        }
                        case 4: {
                            type = "PropertyAdded";
                            break;
                        }
                        case 16: {
                            type = "PropertyChanged";
                            break;
                        }
                        case 8: {
                            type = "PropertyRemoved";
                            break;
                        }
                        case 32: {
                            type = "NodeMoved";
                            break;
                        }
                        case 64: {
                            type = "Persist";
                            break;
                        }
                        default: {
                            type = "Unknown";
                        }
                    }
                    log.debug("  {}; {}", (Object)e.getPath(), (Object)type);
                }
            }
        }
        this.updateSync.acquire();
        try {
            for (EventBundle eventBundle : eventBundles) {
                for (InternalEventListener lstnr : lstnrs) {
                    try {
                        lstnr.onEvent(eventBundle);
                    }
                    catch (Exception e) {
                        log.warn("Exception in event polling thread: " + e);
                        log.debug("Dump:", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.updateSync.release();
        }
    }

    private final class ChangePolling
    implements Runnable {
        private final int pollTimeout;

        private ChangePolling(int pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String wspName = WorkspaceManager.this.sessionInfo.getWorkspaceName();
            while (!Thread.interrupted() && !WorkspaceManager.this.disposeChangeFeed) {
                try {
                    Subscription subscr;
                    InternalEventListener[] iel;
                    List list = WorkspaceManager.this.listeners;
                    synchronized (list) {
                        while (WorkspaceManager.this.subscription == null) {
                            WorkspaceManager.this.listeners.wait();
                        }
                        iel = WorkspaceManager.this.listeners.toArray(new InternalEventListener[WorkspaceManager.this.listeners.size()]);
                        subscr = WorkspaceManager.this.subscription;
                    }
                    log.debug("calling getEvents() (Workspace={})", (Object)wspName);
                    EventBundle[] bundles = WorkspaceManager.this.service.getEvents(subscr, (long)this.pollTimeout);
                    log.debug("returned from getEvents() (Workspace={})", (Object)wspName);
                    if (Thread.interrupted() || WorkspaceManager.this.disposeChangeFeed) {
                        log.debug("Thread interrupted, terminating...");
                        break;
                    }
                    if (bundles.length <= 0) continue;
                    WorkspaceManager.this.onEventReceived(bundles, iel);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    log.error("SPI implementation does not support observation: " + (Object)((Object)e));
                    break;
                }
                catch (RepositoryException e) {
                    log.info("Workspace=" + wspName + ": Exception while retrieving event bundles: " + (Object)((Object)e));
                    log.debug("Dump:", (Throwable)e);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    private final class OperationVisitorImpl
    implements OperationVisitor {
        private final SessionInfo sessionInfo;
        private Batch batch;

        private OperationVisitorImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(ChangeLog changeLog) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
            RepositoryException ex = null;
            try {
                ItemState target = changeLog.getTarget();
                this.batch = WorkspaceManager.this.service.createBatch(this.sessionInfo, target.getId());
                for (Operation op : changeLog.getOperations()) {
                    log.debug("executing " + op.getName());
                    op.accept(this);
                }
            }
            catch (RepositoryException e) {
                ex = e;
            }
            finally {
                if (this.batch != null) {
                    try {
                        WorkspaceManager.this.service.submit(this.batch);
                    }
                    catch (RepositoryException e) {
                        if (ex == null) {
                            ex = e;
                        }
                        log.warn("Exception submitting batch", (Throwable)e);
                    }
                    this.batch = null;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        private void execute(Operation workspaceOperation) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
            log.debug("executing " + workspaceOperation.getName());
            workspaceOperation.accept(this);
        }

        public void visit(AddNode operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            this.batch.addNode(parentId, operation.getNodeName(), operation.getNodeTypeName(), operation.getUuid());
        }

        public void visit(AddProperty operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            Name propertyName = operation.getPropertyName();
            if (operation.isMultiValued()) {
                this.batch.addProperty(parentId, propertyName, operation.getValues());
            } else {
                QValue value = operation.getValues()[0];
                this.batch.addProperty(parentId, propertyName, value);
            }
        }

        public void visit(Clone operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId destParentId = operation.getDestinationParentId();
            WorkspaceManager.this.service.clone(this.sessionInfo, operation.getWorkspaceName(), nId, destParentId, operation.getDestinationName(), operation.isRemoveExisting());
        }

        public void visit(Copy operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId destParentId = operation.getDestinationParentId();
            WorkspaceManager.this.service.copy(this.sessionInfo, operation.getWorkspaceName(), nId, destParentId, operation.getDestinationName());
        }

        public void visit(Move operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
            NodeId moveId = operation.getSourceId();
            NodeId destParentId = operation.getDestinationParentId();
            if (this.batch == null) {
                WorkspaceManager.this.service.move(this.sessionInfo, moveId, destParentId, operation.getDestinationName());
            } else {
                this.batch.move(moveId, destParentId, operation.getDestinationName());
            }
        }

        public void visit(Update operation) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            WorkspaceManager.this.service.update(this.sessionInfo, nId, operation.getSourceWorkspaceName());
        }

        public void visit(Remove operation) throws RepositoryException {
            this.batch.remove(operation.getRemoveId());
        }

        public void visit(SetMixin operation) throws RepositoryException {
            this.batch.setMixins(operation.getNodeId(), operation.getMixinNames());
        }

        public void visit(SetPrimaryType operation) throws RepositoryException {
            this.batch.setPrimaryType(operation.getNodeId(), operation.getPrimaryTypeName());
        }

        public void visit(SetPropertyValue operation) throws RepositoryException {
            PropertyId id = operation.getPropertyId();
            if (operation.isMultiValued()) {
                this.batch.setValue(id, operation.getValues());
            } else {
                this.batch.setValue(id, operation.getValues()[0]);
            }
        }

        public void visit(ReorderNodes operation) throws RepositoryException {
            NodeId parentId = operation.getParentId();
            NodeId insertId = operation.getInsertId();
            NodeId beforeId = operation.getBeforeId();
            this.batch.reorderNodes(parentId, insertId, beforeId);
        }

        public void visit(Checkout operation) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
            if (operation.supportsActivity()) {
                WorkspaceManager.this.service.checkout(this.sessionInfo, operation.getNodeId(), operation.getActivityId());
            } else {
                WorkspaceManager.this.service.checkout(this.sessionInfo, operation.getNodeId());
            }
        }

        public void visit(Checkin operation) throws UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            NodeId newId = WorkspaceManager.this.service.checkin(this.sessionInfo, operation.getNodeId());
            operation.setNewVersionId(newId);
        }

        public void visit(Checkpoint operation) throws UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            NodeId newId = operation.supportsActivity() ? WorkspaceManager.this.service.checkpoint(this.sessionInfo, operation.getNodeId(), operation.getActivityId()) : WorkspaceManager.this.service.checkpoint(this.sessionInfo, operation.getNodeId());
            operation.setNewVersionId(newId);
        }

        public void visit(Restore operation) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            if (nId == null) {
                WorkspaceManager.this.service.restore(this.sessionInfo, operation.getVersionIds(), operation.removeExisting());
            } else {
                Path relPath = operation.getRelativePath();
                NodeId targetId = relPath != null ? WorkspaceManager.this.idFactory.createNodeId(nId, relPath) : nId;
                NodeId versionId = operation.getVersionIds()[0];
                WorkspaceManager.this.service.restore(this.sessionInfo, targetId, versionId, operation.removeExisting());
            }
        }

        public void visit(Merge operation) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
            NodeId nId = operation.getNodeId();
            Iterator failed = operation.isActivityMerge() ? WorkspaceManager.this.service.mergeActivity(this.sessionInfo, nId) : WorkspaceManager.this.service.merge(this.sessionInfo, nId, operation.getSourceWorkspaceName(), operation.bestEffort(), operation.isShallow());
            operation.setFailedIds(failed);
        }

        public void visit(ResolveMergeConflict operation) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
            NodeId nId = operation.getNodeId();
            NodeId[] mergedFailedIds = operation.getMergeFailedIds();
            NodeId[] predecessorIds = operation.getPredecessorIds();
            WorkspaceManager.this.service.resolveMergeConflict(this.sessionInfo, nId, mergedFailedIds, predecessorIds);
        }

        public void visit(LockOperation operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            LockInfo lInfo = WorkspaceManager.this.service.lock(this.sessionInfo, operation.getNodeId(), operation.isDeep(), operation.isSessionScoped(), operation.getTimeoutHint(), operation.getOwnerHint());
            operation.setLockInfo(lInfo);
        }

        public void visit(LockRefresh operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            WorkspaceManager.this.service.refreshLock(this.sessionInfo, operation.getNodeId());
        }

        public void visit(LockRelease operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
            WorkspaceManager.this.service.unlock(this.sessionInfo, operation.getNodeId());
        }

        public void visit(AddLabel operation) throws VersionException, RepositoryException {
            NodeId vhId = operation.getVersionHistoryId();
            NodeId vId = operation.getVersionId();
            WorkspaceManager.this.service.addVersionLabel(this.sessionInfo, vhId, vId, operation.getLabel(), operation.moveLabel());
        }

        public void visit(RemoveLabel operation) throws VersionException, RepositoryException {
            NodeId vhId = operation.getVersionHistoryId();
            NodeId vId = operation.getVersionId();
            WorkspaceManager.this.service.removeVersionLabel(this.sessionInfo, vhId, vId, operation.getLabel());
        }

        public void visit(RemoveVersion operation) throws VersionException, AccessDeniedException, ReferentialIntegrityException, RepositoryException {
            NodeId versionId = (NodeId)operation.getRemoveId();
            NodeState vhState = operation.getParentState();
            WorkspaceManager.this.service.removeVersion(this.sessionInfo, (NodeId)vhState.getWorkspaceId(), versionId);
        }

        public void visit(WorkspaceImport operation) throws RepositoryException {
            WorkspaceManager.this.service.importXml(this.sessionInfo, operation.getNodeId(), operation.getXmlStream(), operation.getUuidBehaviour());
        }

        public void visit(CreateActivity operation) throws RepositoryException {
            NodeId activityId = WorkspaceManager.this.service.createActivity(this.sessionInfo, operation.getTitle());
            operation.setNewActivityId(activityId);
        }

        public void visit(RemoveActivity operation) throws RepositoryException {
            WorkspaceManager.this.service.removeActivity(this.sessionInfo, (NodeId)operation.getRemoveId());
        }

        public void visit(CreateConfiguration operation) throws RepositoryException {
            NodeId configId = WorkspaceManager.this.service.createConfiguration(this.sessionInfo, operation.getNodeId());
            operation.setNewConfigurationId(configId);
        }
    }
}

