/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.operation.AbstractRemove;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.PropertyId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveActivity
extends AbstractRemove {
    private static Logger log = LoggerFactory.getLogger(RemoveActivity.class);
    private final Iterator<PropertyId> refs;
    private final HierarchyManager hMgr;

    private RemoveActivity(NodeState removeActivity, HierarchyManager hierarchyMgr) throws RepositoryException {
        super(removeActivity, removeActivity.getParent());
        this.refs = removeActivity.getNodeReferences(null, false);
        this.hMgr = hierarchyMgr;
    }

    public void accept(OperationVisitor visitor) throws AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        while (this.refs.hasNext()) {
            HierarchyEntry entry = this.hMgr.lookup((ItemId)this.refs.next());
            if (entry == null) continue;
            entry.invalidate(false);
        }
        this.parent.getNodeEntry().invalidate(false);
    }

    public static Operation create(NodeState activityState, HierarchyManager hierarchyMgr) throws RepositoryException {
        RemoveActivity rm = new RemoveActivity(activityState, hierarchyMgr);
        return rm;
    }
}

