/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.TransientOperation;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;

public class SetPrimaryType
extends TransientOperation {
    private static final int SET_PRIMARY_TYPE_OPTIONS = 6;
    private final NodeId nodeId;
    private final NodeState nodeState;
    private final Name primaryTypeName;

    private SetPrimaryType(NodeState nodeState, Name primaryTypeName) throws RepositoryException {
        this(nodeState, primaryTypeName, 6);
    }

    private SetPrimaryType(NodeState nodeState, Name primaryTypeName, int options) throws RepositoryException {
        super(options);
        this.nodeState = nodeState;
        this.nodeId = nodeState.getNodeId();
        this.primaryTypeName = primaryTypeName;
        this.addAffectedItemState(nodeState);
    }

    public void accept(OperationVisitor visitor) throws AccessDeniedException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        this.nodeState.getHierarchyEntry().complete(this);
    }

    public void undo() throws RepositoryException {
        assert (this.status == 0);
        this.status = 2;
        this.nodeState.getHierarchyEntry().complete(this);
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Name getPrimaryTypeName() {
        return this.primaryTypeName;
    }

    public static Operation create(NodeState nodeState, Name primaryTypeName) throws RepositoryException {
        if (nodeState == null || primaryTypeName == null) {
            throw new IllegalArgumentException();
        }
        SetPrimaryType op = new SetPrimaryType(nodeState, primaryTypeName);
        return op;
    }
}

