/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeTypeManager;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeManagerImpl
extends AbstractNodeTypeManager
implements NodeTypeDefinitionProvider,
NodeTypeRegistryListener {
    private static Logger log = LoggerFactory.getLogger(NodeTypeManagerImpl.class);
    private final ManagerProvider mgrProvider;
    private final NodeTypeRegistry ntReg;
    private final ValueFactory valueFactory;
    private final Map<Name, NodeTypeImpl> ntCache;
    private final Map<QPropertyDefinition, PropertyDefinition> pdCache;
    private final Map<QNodeDefinition, NodeDefinition> ndCache;

    public NodeTypeManagerImpl(NodeTypeRegistry ntReg, ManagerProvider mgrProvider) throws RepositoryException {
        this.mgrProvider = mgrProvider;
        this.ntReg = ntReg;
        this.ntReg.addListener(this);
        this.valueFactory = mgrProvider.getJcrValueFactory();
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
    }

    private EffectiveNodeTypeProvider entProvider() {
        return this.mgrProvider.getEffectiveNodeTypeProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeImpl getNodeType(Name name) throws NoSuchNodeTypeException {
        Map<Name, NodeTypeImpl> map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = this.ntCache.get(name);
            if (nt == null) {
                EffectiveNodeType ent = this.entProvider().getEffectiveNodeType(name);
                QNodeTypeDefinition def = this.ntReg.getNodeTypeDefinition(name);
                nt = new NodeTypeImpl(ent, def, this, this.mgrProvider);
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    public NamePathResolver getNamePathResolver() {
        return this.mgrProvider.getNamePathResolver();
    }

    public boolean hasNodeType(Name nodeTypeName) {
        boolean isRegistered = this.ntCache.containsKey(nodeTypeName);
        if (!isRegistered) {
            isRegistered = this.ntReg.isRegistered(nodeTypeName);
        }
        return isRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDefinition getNodeDefinition(QNodeDefinition def) {
        Map<QNodeDefinition, NodeDefinition> map = this.ndCache;
        synchronized (map) {
            NodeDefinition ndi = this.ndCache.get(def);
            if (ndi == null) {
                ndi = new NodeDefinitionImpl((QItemDefinition)def, (AbstractNodeTypeManager)this, this.getNamePathResolver());
                this.ndCache.put(def, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinition getPropertyDefinition(QPropertyDefinition def) {
        Map<QPropertyDefinition, PropertyDefinition> map = this.pdCache;
        synchronized (map) {
            PropertyDefinition pdi = this.pdCache.get(def);
            if (pdi == null) {
                pdi = new PropertyDefinitionImpl(def, (AbstractNodeTypeManager)this, this.getNamePathResolver(), this.valueFactory);
                this.pdCache.put(def, pdi);
            }
            return pdi;
        }
    }

    NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    @Override
    public QNodeTypeDefinition getNodeTypeDefinition(Name ntName) throws NoSuchNodeTypeException, RepositoryException {
        NodeTypeImpl nt = this.getNodeType(ntName);
        return nt.getDefinition();
    }

    @Override
    public void nodeTypeRegistered(Name ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypeReRegistered(Name ntName) {
        this.ntCache.remove(ntName);
        try {
            Iterator<PropertyDefinition> iter;
            String name = this.getNamePathResolver().getJCRName(ntName);
            Map<QPropertyDefinition, PropertyDefinition> map = this.pdCache;
            synchronized (map) {
                iter = this.pdCache.values().iterator();
                while (iter.hasNext()) {
                    PropertyDefinition pd = iter.next();
                    if (!name.equals(pd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
            map = this.ndCache;
            synchronized (map) {
                iter = this.ndCache.values().iterator();
                while (iter.hasNext()) {
                    NodeDefinition nd = (NodeDefinition)iter.next();
                    if (!name.equals(nd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
        }
        catch (NamespaceException e) {
            log.warn(e.getMessage() + " -> clear definition cache.");
            Map<QPropertyDefinition, PropertyDefinition> map = this.pdCache;
            synchronized (map) {
                this.pdCache.clear();
            }
            map = this.ndCache;
            synchronized (map) {
                this.ndCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypeUnregistered(Name ntName) {
        this.ntCache.remove(ntName);
        try {
            Iterator<PropertyDefinition> iter;
            String name = this.getNamePathResolver().getJCRName(ntName);
            Map<QPropertyDefinition, PropertyDefinition> map = this.pdCache;
            synchronized (map) {
                iter = this.pdCache.values().iterator();
                while (iter.hasNext()) {
                    PropertyDefinition pd = iter.next();
                    if (!name.equals(pd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
            map = this.ndCache;
            synchronized (map) {
                iter = this.ndCache.values().iterator();
                while (iter.hasNext()) {
                    NodeDefinition nd = (NodeDefinition)iter.next();
                    if (!name.equals(nd.getDeclaringNodeType().getName())) continue;
                    iter.remove();
                }
            }
        }
        catch (NamespaceException e) {
            log.warn(e.getMessage() + " -> clear definition cache.");
            Map<QPropertyDefinition, PropertyDefinition> map = this.pdCache;
            synchronized (map) {
                this.pdCache.clear();
            }
            map = this.ndCache;
            synchronized (map) {
                this.ndCache.clear();
            }
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Name ntName : ntNames) {
            list.add(this.getNodeType(ntName));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Name ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType(ntName);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Name[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (Name ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType(ntName);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            Name qName = this.getNamePathResolver().getQName(nodeTypeName);
            return this.getNodeType(qName);
        }
        catch (NamespaceException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
        catch (NameException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)e);
        }
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            Name qName = this.getNamePathResolver().getQName(name);
            return this.hasNodeType(qName);
        }
        catch (NamespaceException e) {
            return false;
        }
        catch (NameException e) {
            return false;
        }
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        ArrayList<QNodeTypeDefinition> defs = new ArrayList<QNodeTypeDefinition>(ntds.length);
        for (NodeTypeDefinition definition : ntds) {
            QNodeTypeDefinitionImpl qdef = new QNodeTypeDefinitionImpl(definition, this.getNamePathResolver(), this.mgrProvider.getQValueFactory());
            if (!allowUpdate && this.hasNodeType(qdef.getName())) {
                throw new NodeTypeExistsException("NodeType " + definition.getName() + " already exists.");
            }
            defs.add((QNodeTypeDefinition)qdef);
        }
        this.getNodeTypeRegistry().registerNodeTypes(defs, allowUpdate);
        ArrayList<NodeTypeImpl> nts = new ArrayList<NodeTypeImpl>();
        for (QNodeTypeDefinition def : defs) {
            nts.add(this.getNodeType(def.getName()));
        }
        return new NodeTypeIteratorAdapter(nts);
    }

    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        for (String name : names) {
            ntNames.add(this.getNamePathResolver().getQName(name));
        }
        this.getNodeTypeRegistry().unregisterNodeTypes(ntNames);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeTypeManager (" + super.toString() + ")\n");
        builder.append("All NodeTypes:\n");
        try {
            NodeTypeIterator iter = this.getAllNodeTypes();
            while (iter.hasNext()) {
                NodeType nt = iter.nextNodeType();
                builder.append(nt.getName());
                builder.append("\n\tSupertypes");
                for (NodeType nodeType : nt.getSupertypes()) {
                    builder.append("\n\t\t" + nodeType.getName());
                }
                builder.append("\n\tMixin\t" + nt.isMixin());
                builder.append("\n\tOrderableChildNodes\t" + nt.hasOrderableChildNodes());
                builder.append("\n\tPrimaryItemName\t" + (nt.getPrimaryItemName() == null ? "<null>" : nt.getPrimaryItemName()));
                for (NodeType nodeType : nt.getPropertyDefinitions()) {
                    builder.append("\n\tPropertyDefinition");
                    builder.append(" (declared in " + nodeType.getDeclaringNodeType().getName() + ") ");
                    builder.append("\n\t\tName\t\t" + nodeType.getName());
                    String type = nodeType.getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)nodeType.getRequiredType());
                    builder.append("\n\t\tRequiredType\t" + type);
                    String[] vca = nodeType.getValueConstraints();
                    StringBuffer constraints = new StringBuffer();
                    if (vca == null) {
                        constraints.append("<null>");
                    } else {
                        for (String aVca : vca) {
                            if (constraints.length() > 0) {
                                constraints.append(", ");
                            }
                            constraints.append(aVca);
                        }
                    }
                    builder.append("\n\t\tValueConstraints\t" + constraints.toString());
                    Value[] defVals = nodeType.getDefaultValues();
                    StringBuffer defaultValues = new StringBuffer();
                    if (defVals == null) {
                        defaultValues.append("<null>");
                    } else {
                        for (Value defVal : defVals) {
                            if (defaultValues.length() > 0) {
                                defaultValues.append(", ");
                            }
                            defaultValues.append(defVal.getString());
                        }
                    }
                    builder.append("\n\t\tDefaultValue\t" + defaultValues.toString());
                    builder.append("\n\t\tAutoCreated\t" + nodeType.isAutoCreated());
                    builder.append("\n\t\tMandatory\t" + nodeType.isMandatory());
                    builder.append("\n\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nodeType.getOnParentVersion()));
                    builder.append("\n\t\tProtected\t" + nodeType.isProtected());
                    builder.append("\n\t\tMultiple\t" + nodeType.isMultiple());
                }
                for (NodeType nodeType : nt.getChildNodeDefinitions()) {
                    NodeType defPrimaryType;
                    builder.append("\n\tNodeDefinition");
                    builder.append(" (declared in " + nodeType.getDeclaringNodeType() + ") ");
                    builder.append("\n\t\tName\t\t" + nodeType.getName());
                    NodeType[] reqPrimaryTypes = nodeType.getRequiredPrimaryTypes();
                    if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                        for (NodeType reqPrimaryType : reqPrimaryTypes) {
                            builder.append("\n\t\tRequiredPrimaryType\t" + reqPrimaryType.getName());
                        }
                    }
                    if ((defPrimaryType = nodeType.getDefaultPrimaryType()) != null) {
                        builder.append("\n\t\tDefaultPrimaryType\t" + defPrimaryType.getName());
                    }
                    builder.append("\n\t\tAutoCreated\t" + nodeType.isAutoCreated());
                    builder.append("\n\t\tMandatory\t" + nodeType.isMandatory());
                    builder.append("\n\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nodeType.getOnParentVersion()));
                    builder.append("\n\t\tProtected\t" + nodeType.isProtected());
                    builder.append("\n\t\tAllowsSameNameSiblings\t" + nodeType.allowsSameNameSiblings());
                }
            }
        }
        catch (RepositoryException e) {
            builder.append(e.getMessage());
        }
        return builder.toString();
    }
}

