/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class UtilDateTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)propValue);
        return valueFactory.createValue(calendar);
    }

    public Object getObject(Value value) {
        try {
            Calendar calendar = value.getDate();
            return calendar.getTime();
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value : " + value.toString(), e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return "xs:dateTime('" + valueFactory.createValue(calendar).getString() + "')";
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to get the sting value ", e);
        }
    }
}

