/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.beanconverter.impl;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.beanconverter.BeanConverter;
import org.apache.jackrabbit.ocm.manager.beanconverter.impl.AbstractBeanConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class ReferenceBeanConverterImpl
extends AbstractBeanConverterImpl
implements BeanConverter {
    private static final Log log = LogFactory.getLog(ReferenceBeanConverterImpl.class);

    public ReferenceBeanConverterImpl(Mapper mapper, ObjectConverter objectConverter, AtomicTypeConverterProvider atomicTypeConverterProvider) {
        super(mapper, objectConverter, atomicTypeConverterProvider);
    }

    public void insert(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        this.updateReferenceProperty(parentNode, beanDescriptor, beanClassDescriptor, object);
    }

    public void update(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        this.updateReferenceProperty(parentNode, beanDescriptor, beanClassDescriptor, object);
    }

    public Object getObject(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Class beanClass, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            String uuid = parentNode.getProperty(beanDescriptor.getJcrName()).getString();
            String path = session.getNodeByUUID(uuid).getPath();
            return this.objectConverter.getObject(session, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void remove(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        this.updateReferenceProperty(parentNode, beanDescriptor, beanClassDescriptor, null);
    }

    private void updateReferenceProperty(Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object) {
        try {
            FieldDescriptor fieldDescriptor;
            if (object == null) {
                parentNode.setProperty(beanDescriptor.getJcrName(), (Value)null);
            }
            if ((fieldDescriptor = beanClassDescriptor.getUuidFieldDescriptor()) == null) {
                throw new JcrMappingException("The bean doesn't have an uuid - classdescriptor : " + beanClassDescriptor.getClassName());
            }
            String uuid = (String)ReflectionUtils.getNestedProperty(object, fieldDescriptor.getFieldName());
            parentNode.setProperty(beanDescriptor.getJcrName(), uuid, 9);
        }
        catch (Exception e) {
            throw new ObjectContentManagerException("Impossible to insert the bean attribute into the repository", e);
        }
    }
}

