/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter;

import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.ManageableCollectionImpl;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.ManageableMapImpl;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class ManageableObjectsUtil {
    public static ManageableObjects getManageableObjects(String manageableObjectsClassName) {
        try {
            return (ManageableObjects)ReflectionUtils.newInstance(manageableObjectsClassName);
        }
        catch (Exception e) {
            throw new JcrMappingException("Cannot create manageable collection : " + manageableObjectsClassName, e);
        }
    }

    public static ManageableObjects getManageableObjects(Class manageableObjectsClass) {
        try {
            if (manageableObjectsClass.isInterface()) {
                Class defaultImplementation = ReflectionUtils.getDefaultImplementation(manageableObjectsClass);
                if (defaultImplementation == null) {
                    throw new JcrMappingException("No default implementation for the interface " + manageableObjectsClass);
                }
                manageableObjectsClass = defaultImplementation;
            }
            if (ReflectionUtils.implementsInterface(manageableObjectsClass, Collection.class)) {
                return new ManageableCollectionImpl((Collection)ReflectionUtils.newInstance(manageableObjectsClass));
            }
            if (ReflectionUtils.implementsInterface(manageableObjectsClass, Map.class)) {
                return new ManageableMapImpl((Map)ReflectionUtils.newInstance(manageableObjectsClass));
            }
            Object manageableObjects = manageableObjectsClass.newInstance();
            if (!(manageableObjects instanceof ManageableObjects)) {
                throw new JcrMappingException("Unsupported collection type :" + manageableObjectsClass.getName());
            }
            return (ManageableObjects)manageableObjects;
        }
        catch (Exception e) {
            throw new JcrMappingException("Cannot create manageable objects (Collection or Map)", e);
        }
    }

    public static ManageableObjects getManageableObjects(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof ManageableObjects) {
                return (ManageableObjects)object;
            }
            if (ReflectionUtils.implementsInterface(object.getClass(), Collection.class)) {
                return new ManageableCollectionImpl((Collection)object);
            }
            if (ReflectionUtils.implementsInterface(object.getClass(), Map.class)) {
                return new ManageableMapImpl((Map)object);
            }
        }
        catch (Exception e) {
            throw new JcrMappingException("Impossible to create the manageable collection", e);
        }
        throw new JcrMappingException("Unsupported collection type :" + object.getClass().getName());
    }
}

