/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableMap;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.MapReferenceValueEncoder;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class BeanReferenceMapConverterImpl
extends AbstractCollectionConverterImpl {
    public BeanReferenceMapConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        if (!(objects instanceof ManageableMap)) {
            throw new JcrMappingException("Impossible to retrieve the attribute " + collectionDescriptor.getFieldName() + " in the class " + collectionDescriptor.getClassDescriptor().getClassName() + " because it is not a map");
        }
        this.addUuidProperties(session, parentNode, collectionDescriptor, (ManageableMap)objects);
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        if (!(objects instanceof ManageableMap)) {
            throw new JcrMappingException("Impossible to retrieve the attribute " + collectionDescriptor.getFieldName() + " in the class " + collectionDescriptor.getClassDescriptor().getClassName() + " because it is not a map");
        }
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode.hasProperty(jcrName)) {
            parentNode.setProperty(jcrName, (Value[])null);
        }
        if (objects == null) {
            return;
        }
        this.addUuidProperties(session, parentNode, collectionDescriptor, (ManageableMap)objects);
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            if (!parentNode.hasProperty(jcrName)) {
                return null;
            }
            Property property = parentNode.getProperty(jcrName);
            Value[] values = property.getValues();
            ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
            if (!(objects instanceof ManageableMap)) {
                throw new JcrMappingException("Impossible to retrieve the attribute " + collectionDescriptor.getFieldName() + " in the class " + collectionDescriptor.getClassDescriptor().getClassName() + " because it is not a map");
            }
            for (int i = 0; i < values.length; ++i) {
                String encoded = values[i].getString();
                String key = MapReferenceValueEncoder.decodeKey(encoded);
                String uuid = MapReferenceValueEncoder.decodeReference(encoded);
                String path = session.getNodeByUUID(uuid).getPath();
                Object object = this.objectConverter.getObject(session, path);
                ((ManageableMap)objects).addObject(key, object);
            }
            return objects;
        }
        catch (Exception e) {
            throw new ObjectContentManagerException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), e);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return !parentNode.hasProperty(jcrName);
    }

    private void addUuidProperties(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableMap manageableMap) throws UnsupportedRepositoryOperationException, RepositoryException, VersionException, LockException, ConstraintViolationException {
        try {
            if (manageableMap == null) {
                return;
            }
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            Value[] values = new Value[manageableMap.getSize()];
            ValueFactory valueFactory = session.getValueFactory();
            Map map = (Map)manageableMap.getObjects();
            Iterator keyIterator = map.keySet().iterator();
            for (int i = 0; i < manageableMap.getSize(); ++i) {
                String key = (String)keyIterator.next();
                Object object = map.get(key);
                if (object == null) continue;
                ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(object.getClass());
                FieldDescriptor fieldDescriptor = classDescriptor.getUuidFieldDescriptor();
                if (fieldDescriptor == null) {
                    throw new JcrMappingException("The bean doesn't have an uuid - classdescriptor : " + classDescriptor.getClassName());
                }
                String uuid = (String)ReflectionUtils.getNestedProperty(object, fieldDescriptor.getFieldName());
                values[i] = valueFactory.createValue(MapReferenceValueEncoder.encodeKeyAndReference(key, uuid), 1);
            }
            parentNode.setProperty(jcrName, values);
        }
        catch (Exception e) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), e);
        }
    }
}

