/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableMap;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class NTCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    private static final Log log = LogFactory.getLog(NTCollectionConverterImpl.class);
    protected static final String COLLECTION_ELEMENT_NAME = "collection-element";

    public NTCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) {
        if (objects == null) {
            return;
        }
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Iterator collectionIterator = objects.getIterator();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
            } else {
                elementJcrName = collectionDescriptor.getJcrElementName();
                if (elementJcrName == null) {
                    elementJcrName = COLLECTION_ELEMENT_NAME;
                }
            }
            this.objectConverter.insert(session, parentNode, elementJcrName, item);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        if (objects == null || !elementClassDescriptor.hasIdField()) {
            this.deleteCollectionItems(session, parentNode, elementClassDescriptor.getJcrType());
        }
        if (objects == null) {
            return;
        }
        Iterator collectionIterator = objects.getIterator();
        HashMap updatedItems = new HashMap();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
                if (parentNode.hasNode(elementJcrName)) {
                    this.objectConverter.update(session, parentNode, elementJcrName, item);
                } else {
                    this.objectConverter.insert(session, parentNode, elementJcrName, item);
                }
                updatedItems.put(elementJcrName, item);
                continue;
            }
            elementJcrName = collectionDescriptor.getJcrElementName();
            if (elementJcrName == null) {
                elementJcrName = COLLECTION_ELEMENT_NAME;
            }
            this.objectConverter.insert(session, parentNode, elementJcrName, item);
        }
        NodeIterator nodes = this.getCollectionNodes(session, parentNode, elementClassDescriptor.getJcrType());
        if (nodes != null && elementClassDescriptor.hasIdField()) {
            while (nodes.hasNext()) {
                Node child = (Node)nodes.next();
                if (updatedItems.containsKey(child.getName())) continue;
                child.remove();
            }
        }
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
        NodeIterator nodes = this.getCollectionNodes(session, parentNode, elementClassDescriptor.getJcrType());
        if (nodes == null || nodes.getSize() == 0L) {
            return null;
        }
        while (nodes.hasNext()) {
            Node itemNode = (Node)nodes.next();
            log.debug((Object)("Collection node found : " + itemNode.getPath()));
            Object item = this.objectConverter.getObject(session, itemNode.getPath());
            this.mapper.getClassDescriptorByClass(item.getClass());
            if (objects instanceof ManageableCollection) {
                ((ManageableCollection)objects).addObject(item);
                continue;
            }
            if (!elementClassDescriptor.hasIdField()) {
                throw new JcrMappingException("Impossible to use a map for the field : " + collectionDescriptor.getFieldName() + "in the class : " + collectionDescriptor.getCollectionClassName() + ". The element objects have no id field (check their OCM mapping)");
            }
            Object elementId = ReflectionUtils.getNestedProperty(item, elementClassDescriptor.getIdFieldDescriptor().getFieldName());
            ((ManageableMap)objects).addObject(elementId, item);
        }
        return objects;
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String elementClassName = collectionDescriptor.getElementClassName();
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(elementClassName));
        QueryResult queryResult = this.getQuery(session, parentNode, elementClassDescriptor.getJcrType());
        return queryResult.getNodes().getSize() == 0L;
    }

    private NodeIterator getCollectionNodes(Session session, Node parentNode, String itemNodeType) throws PathNotFoundException, ValueFormatException, RepositoryException {
        Object collectionNodes = null;
        QueryResult queryResult = this.getQuery(session, parentNode, itemNodeType);
        return queryResult.getNodes();
    }

    private void deleteCollectionItems(Session session, Node parentNode, String itemNodeType) throws VersionException, LockException, ConstraintViolationException, PathNotFoundException, ValueFormatException, RepositoryException {
        NodeIterator nodes = this.getCollectionNodes(session, parentNode, itemNodeType);
        if (nodes == null || nodes.getSize() == 0L) {
            return;
        }
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            node.remove();
        }
    }

    private QueryResult getQuery(Session session, Node parentNode, String jcrNodeType) throws RepositoryException, InvalidQueryException {
        String jcrExpression = "";
        jcrExpression = !parentNode.getPath().startsWith("/jcr:system/jcr:versionStorage") ? "SELECT * FROM " + jcrNodeType + " WHERE jcr:path LIKE '" + parentNode.getPath() + "/%' AND NOT jcr:path LIKE '" + parentNode.getPath() + "/%/%'" : "SELECT * FROM nt:frozenNode WHERE jcr:path LIKE '" + parentNode.getPath() + "/%'" + " AND NOT jcr:path LIKE '" + parentNode.getPath() + "/%/%'" + " AND jcr:frozenPrimaryType = '" + jcrNodeType + "'";
        Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(jcrExpression, "sql");
        QueryResult queryResult = jcrQuery.execute();
        return queryResult;
    }
}

