/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.mapper.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;

public class MappingDescriptor {
    private static final Log log = LogFactory.getLog(MappingDescriptor.class);
    private HashMap classDescriptorsByClassName = new HashMap();
    private HashMap classDescriptorsByNodeType = new HashMap();
    private Mapper mapper;
    private String packageName;

    public void setPackage(String pckgName) {
        this.packageName = pckgName;
    }

    public void addClassDescriptor(ClassDescriptor classDescriptor) {
        if (this.classDescriptorsByClassName.get(classDescriptor.getClassName()) != null) {
            log.warn((Object)("Duplicate classdescriptor for : " + classDescriptor.getClassName() + ". The mapping setting will be overriden"));
        }
        log.debug((Object)("Adding the class descriptor for : " + classDescriptor.getClassName()));
        if (null != this.packageName && !"".equals(this.packageName)) {
            classDescriptor.setClassName(this.packageName + "." + classDescriptor.getClassName());
            if (null != classDescriptor.getExtend() && !"".equals(classDescriptor.getExtend())) {
                classDescriptor.setExtend(this.packageName + "." + classDescriptor.getExtend());
            }
        }
        this.classDescriptorsByClassName.put(classDescriptor.getClassName(), classDescriptor);
        if (null != classDescriptor.getJcrType() && !"".equals(classDescriptor.getJcrType()) && !"nt:unstructured".equals(classDescriptor.getJcrType())) {
            if (this.classDescriptorsByNodeType.get(classDescriptor.getJcrType()) != null && classDescriptor.usesNodeTypePerConcreteClassStrategy()) {
                log.warn((Object)("Duplicate classdescriptor for node type : " + classDescriptor.getJcrType()));
            }
            this.classDescriptorsByNodeType.put(classDescriptor.getJcrType(), classDescriptor);
        }
        classDescriptor.setMappingDescriptor(this);
    }

    public ClassDescriptor getClassDescriptorByName(String className) {
        return (ClassDescriptor)this.classDescriptorsByClassName.get(className);
    }

    public ClassDescriptor getClassDescriptorByNodeType(String nodeType) {
        return (ClassDescriptor)this.classDescriptorsByNodeType.get(nodeType);
    }

    public Collection getAllClassDescriptors() {
        return this.classDescriptorsByClassName.values();
    }

    public Map getClassDescriptorsByClassName() {
        return this.classDescriptorsByClassName;
    }

    public Map getClassDescriptorsByNodeType() {
        return this.classDescriptorsByNodeType;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper parentMapper) {
        this.mapper = parentMapper;
    }
}

