/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.conversion;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathParser;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;

public class ParsingPathResolver
implements PathResolver {
    private final PathFactory pathFactory;
    private final NameResolver resolver;

    public ParsingPathResolver(PathFactory pathFactory, NameResolver resolver) {
        this.pathFactory = pathFactory;
        this.resolver = resolver;
    }

    public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
        return PathParser.parse(path, this.resolver, this.pathFactory);
    }

    public String getJCRPath(Path path) throws NamespaceException {
        StringBuffer buffer = new StringBuffer();
        Path.Element[] elements = path.getElements();
        int i = 0;
        while (i < elements.length) {
            if (i > 0) {
                buffer.append('/');
            }
            if (i == 0 && elements.length == 1 && elements[i].denotesRoot()) {
                buffer.append('/');
            } else if (elements[i].denotesCurrent()) {
                buffer.append('.');
            } else if (elements[i].denotesParent()) {
                buffer.append("..");
            } else {
                buffer.append(this.resolver.getJCRName(elements[i].getName()));
                if (elements[i].getIndex() > 1) {
                    buffer.append('[');
                    buffer.append(elements[i].getIndex());
                    buffer.append(']');
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

