/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype.compact;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.compact.Lexer;
import org.apache.jackrabbit.spi.commons.nodetype.compact.ParseException;
import org.apache.jackrabbit.spi.commons.nodetype.compact.QNodeTypeDefinitionsBuilder;
import org.apache.jackrabbit.util.ISO9075;

public class CompactNodeTypeDefReader {
    private static final String[] EMPTY_VALUE_CONSTRAINTS = new String[0];
    private final List nodeTypeDefs = new LinkedList();
    private final NamespaceMapping nsMapping;
    private final NamePathResolver resolver;
    private final Lexer lexer;
    private String currentToken;
    private final QNodeTypeDefinitionsBuilder builder;

    public CompactNodeTypeDefReader(Reader r, String systemId, QNodeTypeDefinitionsBuilder builder) throws ParseException {
        this(r, systemId, new NamespaceMapping(), builder);
    }

    public CompactNodeTypeDefReader(Reader r, String systemId, NamespaceMapping mapping, QNodeTypeDefinitionsBuilder builder) throws ParseException {
        this.builder = builder;
        this.lexer = new Lexer(r, systemId);
        this.nsMapping = mapping;
        this.resolver = new DefaultNamePathResolver(this.nsMapping);
        this.nextToken();
        this.parse();
    }

    public List getNodeTypeDefs() {
        return this.nodeTypeDefs;
    }

    public NamespaceMapping getNamespaceMapping() {
        return this.nsMapping;
    }

    private void parse() throws ParseException {
        while (!this.currentTokenEquals("eof")) {
            if (!this.doNameSpace()) break;
        }
        while (!this.currentTokenEquals("eof")) {
            QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd = this.builder.newQNodeTypeDefinition();
            ntd.setOrderableChildNodes(false);
            ntd.setMixin(false);
            ntd.setPrimaryItemName(null);
            this.doNodeTypeName(ntd);
            this.doSuperTypes(ntd);
            this.doOptions(ntd);
            this.doItemDefs(ntd);
            this.nodeTypeDefs.add(ntd.build());
        }
    }

    private boolean doNameSpace() throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        try {
            this.nsMapping.setMapping(prefix, uri);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        this.nextToken();
        return true;
    }

    private void doNodeTypeName(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Missing '[' delimiter for beginning of node type name");
        }
        this.nextToken();
        ntd.setName(this.toName(this.currentToken));
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
    }

    private void doSuperTypes(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        ArrayList<Name> supertypes = new ArrayList<Name>();
        if (this.currentTokenEquals('>')) {
            do {
                this.nextToken();
                supertypes.add(this.toName(this.currentToken));
                this.nextToken();
            } while (this.currentTokenEquals(','));
        }
        ntd.setSupertypes(supertypes.toArray(new Name[0]));
    }

    private void doOptions(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (this.currentTokenEquals(Lexer.ORDERABLE)) {
            ntd.setOrderableChildNodes(true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.MIXIN)) {
                ntd.setMixin(true);
                this.nextToken();
            }
        } else if (this.currentTokenEquals(Lexer.MIXIN)) {
            ntd.setMixin(true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.ORDERABLE)) {
                ntd.setOrderableChildNodes(true);
                this.nextToken();
            }
        }
    }

    private void doItemDefs(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        ArrayList<QPropertyDefinition> propertyDefinitions = new ArrayList<QPropertyDefinition>();
        ArrayList<QNodeDefinition> nodeDefinitions = new ArrayList<QNodeDefinition>();
        while (this.currentTokenEquals('-') || this.currentTokenEquals('+')) {
            if (this.currentTokenEquals('-')) {
                QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd = ntd.newQPropertyDefinition();
                pd.setAutoCreated(false);
                pd.setDeclaringNodeType(ntd.getName());
                pd.setDefaultValues(null);
                pd.setMandatory(false);
                pd.setMultiple(false);
                pd.setOnParentVersion(1);
                pd.setProtected(false);
                pd.setRequiredType(1);
                pd.setValueConstraints(EMPTY_VALUE_CONSTRAINTS);
                this.nextToken();
                this.doPropertyDefinition(pd, ntd);
                propertyDefinitions.add(pd.build());
                continue;
            }
            if (!this.currentTokenEquals('+')) continue;
            QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd = ntd.newQNodeDefinitionBuilder();
            nd.setAllowsSameNameSiblings(false);
            nd.setAutoCreated(false);
            nd.setDeclaringNodeType(ntd.getName());
            nd.setMandatory(false);
            nd.setOnParentVersion(1);
            nd.setProtected(false);
            nd.setDefaultPrimaryType(null);
            nd.setRequiredPrimaryTypes(new Name[]{NameConstants.NT_BASE});
            this.nextToken();
            this.doChildNodeDefinition(nd, ntd);
            nodeDefinitions.add(nd.build());
        }
        ntd.setPropertyDefs(propertyDefinitions.toArray(new QPropertyDefinition[0]));
        ntd.setChildNodeDefs(nodeDefinitions.toArray(new QNodeDefinition[0]));
    }

    private void doPropertyDefinition(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (this.currentToken.equals("*")) {
            pd.setName(NameConstants.ANY_NAME);
        } else {
            pd.setName(this.toName(this.currentToken));
        }
        this.nextToken();
        this.doPropertyType(pd);
        this.doPropertyDefaultValue(pd);
        this.doPropertyAttributes(pd, ntd);
        this.doPropertyValueConstraints(pd);
    }

    private void doPropertyType(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        this.nextToken();
        if (this.currentTokenEquals(Lexer.STRING)) {
            pd.setRequiredType(1);
        } else if (this.currentTokenEquals(Lexer.BINARY)) {
            pd.setRequiredType(2);
        } else if (this.currentTokenEquals(Lexer.LONG)) {
            pd.setRequiredType(3);
        } else if (this.currentTokenEquals(Lexer.DOUBLE)) {
            pd.setRequiredType(4);
        } else if (this.currentTokenEquals(Lexer.BOOLEAN)) {
            pd.setRequiredType(6);
        } else if (this.currentTokenEquals(Lexer.DATE)) {
            pd.setRequiredType(5);
        } else if (this.currentTokenEquals(Lexer.NAME)) {
            pd.setRequiredType(7);
        } else if (this.currentTokenEquals(Lexer.PATH)) {
            pd.setRequiredType(8);
        } else if (this.currentTokenEquals(Lexer.REFERENCE)) {
            pd.setRequiredType(9);
        } else if (this.currentTokenEquals(Lexer.UNDEFINED)) {
            pd.setRequiredType(0);
        } else {
            this.lexer.fail("Unkown property type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (!this.currentTokenEquals(')')) {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
        this.nextToken();
    }

    private void doPropertyAttributes(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = this.resolver.getJCRName(ntd.getName());
                    }
                    catch (NamespaceException namespaceException) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(pd.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                pd.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                pd.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                pd.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                pd.setMultiple(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                pd.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                pd.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                pd.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                pd.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                pd.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                pd.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private void doPropertyDefaultValue(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        ArrayList<QValue> defaultValues = new ArrayList<QValue>();
        do {
            this.nextToken();
            QValue value = null;
            try {
                value = pd.createValue(this.currentToken, this.resolver);
            }
            catch (ValueFormatException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid string representation of a value of type " + pd.getRequiredType());
            }
            catch (RepositoryException e) {
                this.lexer.fail("An error occured during value conversion of '" + this.currentToken + "'");
            }
            defaultValues.add(value);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pd.setDefaultValues(defaultValues.toArray(new QValue[0]));
    }

    private void doPropertyValueConstraints(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        ArrayList<String> constraints = new ArrayList<String>();
        do {
            this.nextToken();
            String constraint = null;
            try {
                constraint = pd.createValueConstraint(this.currentToken, this.resolver);
            }
            catch (InvalidConstraintException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid constraint expression for a value of type " + pd.getRequiredType());
            }
            constraints.add(constraint);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pd.setValueConstraints(constraints.toArray(new String[0]));
    }

    private void doChildNodeDefinition(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (this.currentTokenEquals('*')) {
            nd.setName(NameConstants.ANY_NAME);
        } else {
            nd.setName(this.toName(this.currentToken));
        }
        this.nextToken();
        this.doChildNodeRequiredTypes(nd);
        this.doChildNodeDefaultType(nd);
        this.doChildNodeAttributes(nd, ntd);
    }

    private void doChildNodeRequiredTypes(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        ArrayList<Name> types = new ArrayList<Name>();
        do {
            this.nextToken();
            types.add(this.toName(this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        nd.setRequiredPrimaryTypes(types.toArray(new Name[0]));
        this.nextToken();
    }

    private void doChildNodeDefaultType(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        nd.setDefaultPrimaryType(this.toName(this.currentToken));
        this.nextToken();
    }

    private void doChildNodeAttributes(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = this.resolver.getJCRName(ntd.getName());
                    }
                    catch (NamespaceException namespaceException) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(nd.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                nd.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                nd.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                nd.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                nd.setAllowsSameNameSiblings(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                nd.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                nd.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                nd.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                nd.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                nd.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                nd.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private Name toName(String stringName) throws ParseException {
        try {
            Name n = this.resolver.getQName(stringName);
            String decodedLocalName = ISO9075.decode((String)n.getLocalName());
            return this.builder.createName(n.getNamespaceURI(), decodedLocalName);
        }
        catch (NameException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", (Throwable)((Object)e));
            return null;
        }
        catch (NamespaceException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", e);
            return null;
        }
    }

    private void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    private boolean currentTokenEquals(String[] s) {
        int i = 0;
        while (i < s.length) {
            if (this.currentToken.equals(s[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    private boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }
}

