/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.spi.commons.query.QueryTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTreeBuilderRegistry {
    private static final Logger log;
    private static final List BUILDERS;
    private static final Set LANGUAGES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.spi.commons.query.QueryTreeBuilderRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        BUILDERS = new ArrayList();
        HashSet<String> languages = new HashSet<String>();
        try {
            Class<?> clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.apache.jackrabbit.spi.commons.query.QueryTreeBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.apache.jackrabbit.spi.commons.query.QueryTreeBuilderRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Iterator<?> it = ServiceRegistry.lookupProviders(clazz3, clazz2.getClassLoader());
            while (it.hasNext()) {
                QueryTreeBuilder qtb = (QueryTreeBuilder)it.next();
                BUILDERS.add(qtb);
                languages.addAll(Arrays.asList(qtb.getSupportedLanguages()));
            }
        }
        catch (Error e) {
            log.warn("Unable to load providers for QueryTreeBuilder: " + e);
        }
        LANGUAGES = Collections.unmodifiableSet(languages);
    }

    public static QueryTreeBuilder getQueryTreeBuilder(String language) throws InvalidQueryException {
        int i = 0;
        while (i < BUILDERS.size()) {
            QueryTreeBuilder builder = (QueryTreeBuilder)BUILDERS.get(i);
            if (builder.canHandle(language)) {
                return builder;
            }
            ++i;
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }

    public static String[] getSupportedLanguages() {
        return LANGUAGES.toArray(new String[LANGUAGES.size()]);
    }
}

