/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public final class QValueValue
implements Value {
    private static final short STATE_UNDEFINED = 0;
    private static final short STATE_VALUE_CONSUMED = 1;
    private static final short STATE_STREAM_CONSUMED = 2;
    private short state = 0;
    private final QValue qvalue;
    private InputStream stream = null;
    private final NamePathResolver resolver;

    public QValueValue(QValue qvalue, NamePathResolver resolver) {
        this.qvalue = qvalue;
        this.resolver = resolver;
    }

    public QValue getQValue() {
        return this.qvalue;
    }

    public boolean getBoolean() throws RepositoryException {
        this.setValueConsumed();
        if (this.getType() == 1 || this.getType() == 2 || this.getType() == 6) {
            return Boolean.valueOf(this.qvalue.getString());
        }
        throw new ValueFormatException("incompatible type " + PropertyType.nameFromValue((int)this.qvalue.getType()));
    }

    public Calendar getDate() throws RepositoryException {
        this.setValueConsumed();
        return this.qvalue.getCalendar();
    }

    public double getDouble() throws RepositoryException {
        this.setValueConsumed();
        return this.qvalue.getDouble();
    }

    public long getLong() throws RepositoryException {
        this.setValueConsumed();
        return this.qvalue.getLong();
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        this.setStreamConsumed();
        if (this.stream == null) {
            if (this.getType() == 7 || this.getType() == 8) {
                try {
                    String l_s = this.getType() == 7 ? this.resolver.getJCRName(this.qvalue.getName()) : this.resolver.getJCRPath(this.qvalue.getPath());
                    this.stream = new ByteArrayInputStream(l_s.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RepositoryException((Throwable)ex);
                }
            } else {
                this.stream = this.qvalue.getStream();
            }
        }
        return this.stream;
    }

    public String getString() throws RepositoryException {
        this.setValueConsumed();
        if (this.getType() == 7) {
            return this.resolver.getJCRName(this.qvalue.getName());
        }
        if (this.getType() == 8) {
            return this.resolver.getJCRPath(this.qvalue.getPath());
        }
        return this.qvalue.getString();
    }

    public int getType() {
        return this.qvalue.getType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QValueValue) {
            return this.qvalue.equals(((QValueValue)obj).qvalue);
        }
        return false;
    }

    public int hashCode() {
        return this.qvalue.hashCode();
    }

    private void setStreamConsumed() throws IllegalStateException {
        if (this.state == 1) {
            throw new IllegalStateException("non-stream value has already been consumed");
        }
        this.state = (short)2;
    }

    private void setValueConsumed() throws IllegalStateException {
        if (this.state == 2) {
            throw new IllegalStateException("stream value has already been consumed");
        }
        this.state = 1;
    }
}

