/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.spi.commons.query.qom;

import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

import org.apache.jackrabbit.spi.commons.query.jsr283.qom.Constraint;

/**
 * <code>ConstraintImpl</code> is the common basis for classes that implement
 * the {@link org.apache.jackrabbit.spi.commons.query.jsr283.qom.Constraint} interface.
 */
public abstract class ConstraintImpl
        extends AbstractQOMNode
        implements Constraint {

    public ConstraintImpl(NamePathResolver resolver) {
        super(resolver);
    }
}
