/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi2dav.QItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNodeDefinitionImpl
extends QItemDefinitionImpl
implements QNodeDefinition {
    private final Name defaultPrimaryType;
    private final Name[] requiredPrimaryTypes;
    private final boolean allowsSameNameSiblings;

    QNodeDefinitionImpl(Name declaringNodeType, Element ndefElement, NamePathResolver resolver) throws RepositoryException {
        super(declaringNodeType, ndefElement, resolver);
        try {
            this.defaultPrimaryType = ndefElement.hasAttribute("defaultPrimaryType") ? resolver.getQName(ndefElement.getAttribute("defaultPrimaryType")) : null;
            Element reqPrimaryTypes = DomUtil.getChildElement((Node)ndefElement, (String)"requiredPrimaryTypes", null);
            if (reqPrimaryTypes != null) {
                ArrayList<Name> qNames = new ArrayList<Name>();
                ElementIterator it = DomUtil.getChildren((Element)reqPrimaryTypes, (String)"requiredPrimaryType", null);
                while (it.hasNext()) {
                    qNames.add(resolver.getQName(DomUtil.getTextTrim((Element)it.nextElement())));
                }
                this.requiredPrimaryTypes = qNames.toArray(new Name[qNames.size()]);
            } else {
                this.requiredPrimaryTypes = new Name[]{NameConstants.NT_BASE};
            }
            this.allowsSameNameSiblings = ndefElement.hasAttribute("sameNameSiblings") ? Boolean.valueOf(ndefElement.getAttribute("sameNameSiblings")) : false;
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Name getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    public Name[] getRequiredPrimaryTypes() {
        return this.requiredPrimaryTypes;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    public boolean definesNode() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QNodeDefinition) {
            QNodeDefinition other = (QNodeDefinition)obj;
            return super.equals(obj) && Arrays.equals(this.requiredPrimaryTypes, other.getRequiredPrimaryTypes()) && (this.defaultPrimaryType == null ? other.getDefaultPrimaryType() == null : this.defaultPrimaryType.equals(other.getDefaultPrimaryType())) && this.allowsSameNameSiblings == other.allowsSameNameSiblings();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            if (this.getDeclaringNodeType() != null) {
                sb.append(this.getDeclaringNodeType().toString());
                sb.append('/');
            }
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            TreeSet<Name> set = new TreeSet<Name>();
            Name[] names = this.getRequiredPrimaryTypes();
            for (int i = 0; i < names.length; ++i) {
                set.add(names[i]);
            }
            sb.append(set.toString());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

